/*
    GTKmathplot - a simple GTK+ based program
    to plot mathematical functions.
    Copyright (C) 2012, 2013  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __UTILS__
#define __UTILS__

#include"gr.h"

typedef struct {
  /* 
    Mw: Maximal width of a single character
    Mh: Maximal height of a single character

    Validity conditions:
    Mx, My >= 1.0 
  */
  double Mw, Mh;

  /*
    tab_width: Number of spaces which a tabulation amounts to

    Validity condition:
    tab_width >= 1
   */
  unsigned int tab_width;

  /*
    Validity condition:
    line_spacing >= 0.0
   */
  double line_spacing;

  /*
    left: left margin of the print area
    right: right margin of the print area
    top: upper margin of the print area
    bottom: lower margin of the print area

    Validity conditions:
    right >= left + 2 * tab_width * Mw
    bottom >= top + Mh + line_spacing
   */
  double left, right;
  double top, bottom;
} print_specs;

typedef struct {
  double x,y;
} cursor_position;

typedef enum {
  No_error = 0,
  Invalid_parameters,
  Cursor_outside_print_area,
  Missing_space,
  Nerror_codes,
} fmt_error_code;

int is_value_finite (double x);
grchar* xstralloc (size_t n);
grchar* xstrdup (const grchar* caption);
size_t xstrlen (const grchar* s);
void xfree (grchar** pstr);
char *xstrrealloc(char *ptr, size_t size);
void notify_math_error (const char* prefix, 
                        const char* error_msg, 
                        const char* message);
const char* get_last_math_error (void);

grint gstrcmp (const grchar* s1, const grchar* s2);

int str_2_ulng (const grchar* str, unsigned long* value);
const char* str_2_double (const grchar* str, double* value);
grint str_2_number (const char* str, unsigned N);

int read_from_string (const char* str, const char* prefix_to_skip, 
		      char* buffer, unsigned long nbytes);

int evaluator_set (unsigned evaluator, const char* eq);
double evaluator_evaluate (unsigned evaluator, int count,
			   const char** names, const double* values);
gruint which_variables (unsigned func);

int is_space (char ch);
int is_string_blank (const char* str);
int is_special_char (char ch);
int no_other_char_in_string (const char* s, char ch);
char* convert (const char* str, const char* s1, const char* s2);

void cartesian_to_parametric (graphic_mode mode,
			      const char* eq, 
			      char** x_eq, char** y_eq, char** z_eq);
int parametric_to_cartesian (graphic_mode mode, grmathtype type,
			     const char* x_eq, const char* y_eq, 
			     const char* z_eq,
			     char** eq);

double smart_round (double x, double g, unsigned n);

int add_line_to_text (char** pfmt_text, size_t nleading_spaces,
		      const char* str, size_t nbytes);
char* write_text_to_area (const char* text, print_specs settings, 
			  unsigned int tabs, cursor_position start_pos,
			  fmt_error_code* err, double* end_pos_y);
#endif /* __UTILS__ */
