/*
    GTKmathplot - a simple GTK+ based program
    to plot mathematical functions.
    Copyright (C) 2012, 2013  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __GR__
#define __GR__

#define STR_2_OK     0
#define STR_2_UFLOW  1
#define STR_2_OFLOW  2
#define STR_2_NAN    3
#define GR_EPSILON 1.0e-10

typedef char grchar;
typedef long grint;
typedef unsigned long gruint;

typedef enum {
  GRAPHIC_2D = 2,
  GRAPHIC_3D = 3
} graphic_mode; 

typedef enum {
  GR_NONE = 0,
  GR_POINT,
  GR_SEGMENT,
  GR_TRIANGLE
} grtype;

typedef enum {
  GRMATH_BAD = -1, 
  GRMATH_EMPTY = 0,
  GRMATH_CURVE = 1,
  GRMATH_SURFACE = 2
} grmathtype;

typedef enum {
  GRSTYLE_NONE = 0,
  GRSTYLE_DOTTED,
  GRSTYLE_STROKED,
  GRSTYLE_FILLED
} grstyle;

typedef enum {
  GR_EXCEPTION = -2,
  GR_FAILURE = -1,
  GR_NO_ACTION = 0,
  GR_OK = 1
} grexitstatus;

#endif /* __GR__ */
