/*
    GTKmathplot - a simple GTK+ based program
    to plot mathematical functions.
    Copyright (C) 2012, 2013  Ivano Primi  <ivprimi@libero.it>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __GNUPLOT__
#define __GNUPLOT__

#include"gr.h"
#include"gr2d.h"
#include"gr3d.h"

#define DOTTED_COMM  "##DOTTED"
#define STROKED_COMM "##STROKED"
#define FILLED_COMM  "##FILLED"
#define CAPTION_COMM "##CAPTION:"

/*
  Load the objects read from the file pointed to by FP either in the
  pipeline pointed to by POBJ2D or in the one pointed to by POBJ3D.
  Return -1 in case of error, and the dimension of the pipeline (either
  2 or 3) in case of successful loading.
  Remarks:

  1. FILEPATH should be the path of the file pointed to by FP.
  2. The file pointed to by FP must be formatted according to the
     GNUPlot rules.
  3. The function assumes that the pipeline pointed to by POBJ2D (POBJ3D)
     has been properly initialized.
  4. If the returned value is 3 (2), then the objects loaded from the file have
     been added to the pipeline pointed to by POBJ3D (POBJ2D respectively), and 
     the pipeline pointed to by POBJ2D (POBJ3D) has been left unchanged.
  5. In case of error (returned value -1), it is not possible to say
     if any pipeline (and which one) has been modified by the function.
*/
int load_objects_from_file (const char* filepath, FILE* fp, 
			    gr2d_object* pobj2d, gr3d_object* pobj3d);

/*
  Regenerate the internal lists of the IDs which
  are still available for loading objects from a file.

  Remark: This function should be called only by the main function
  and by the display callback. MODE should be the current
  graphic mode (but in main both GRAPHIC_2D and GRAPHIC_3D should
  be used).
*/
void refresh_lists_available_ids(graphic_mode mode);

/*
  Mark all IDS as used.

  This function should be called after loading a MGR file.
*/
void mark_all_ids_as_used (void);

/*
  Return the label associated to the object with identifier ID,
  or NULL if this object has not been loaded from a file.
  MODE should be the graphic mode currently in used, i.e. either GRAPHIC_2D or
  GRAPHIC_3D, if not then return NULL.
*/
const grchar* get_object_caption (graphic_mode mode, int id);

/*
  Re-initialize the internal lists of the captions of the objects
  loaded from GDAT files. MODE should be the current graphic mode.

  Remark: This function should always be called when a 
          refresh_lists_available_ids() is needed.
*/
void reinit_captions (graphic_mode mode);

#endif /* __GNUPLOT__ */
