#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import diacanvas as dia
import nodept
import edgept
import editiontool
import vcnode
import vcedge

class view (dia.CanvasView):
	def __init__ (self, gui, **kw):
		dia.CanvasView.__init__(self, **kw)
		self.gui = gui
		self.edition_tool = editiontool.EditionTool ()
		self.set_normal_mode()
		
	def set_add_node_mode (self, create_node):
		print 'setting ADD NODE MODE'
		self.gui.write_msg('Click on the canvas to add a node. Press Control to add multiples nodes.')
		tool = nodept.PlacementTool(self, create_node)
		self.set_tool(tool)
#		tool.signal_id = tool.connect('button_press_event', create_node, self)

	def set_add_edge_mode (self, create_edge):
		print 'SETTING ADD EDGE MODE'
		self.gui.write_msg('Click on the FROM node (the originating node)')
		tool = edgept.PlacementTool(self, create_edge)
		self.set_tool(tool)
#		tool.signal_id = tool.connect('button_press_event', create_edge, self)


        # c'est la fonction ( renommer -> set_remove_node)
	#qui efface la selection
	def set_remove_node_mode (self, remove_node):
		self.delete_selection()
		self.gui.tb_normal_mode()

	# fonction  enlever
	def set_remove_edge_mode (self, remove_edge):
		self.gui.tb_normal_mode()

	def set_normal_mode (self, data=None):
		self.set_tool(self.edition_tool)
		self.unselect_all()
		
	def delete_selection (self, junk=None):
		self.gui.write_msg('Removing all selected objects ...')
		for item in self.selected_items:			
			if item.item and item.item.parent:
				#print dir(item)
				#print item.item
				#print item.item.parent
				#print dir(item.item.parent)
				self.unselect(item)
				item.item.delete ()							
		self.gui.write_msg('All selected objects removed!')
