#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
import gobject
import gtk
import pango
import diacanvas as dia
from placementtool import *

class VcEdge (dia.CanvasEdge, dia.CanvasAbstractGroup):
    def __init__(self, canvas):
        #print "VcEdge __init__"
        self.__gobject_init__()
        self.set_directed (True)
        self._first_node = None
        self._second_node = None
        self.handles[0].set_property('movable', False)
        self.handles[1].set_property('movable', False)
        #on se lie au canvas
        canvas.root.add (self)

#    def init_shapes (self):
#        self._shapes = []

    def __del__(self):
        #print "VcEdge.__del__"
        self.disconnect_handles ()
        self.set (parent=None)        

    def set_directed (self, val):
        if val:
            self.set (has_head=1)
            self.set (head_a=5, head_b=15, head_c=5, head_d=5)
            #self.set (has_mid=1)
            #self.set (mid_a=5, mid_b=15, mid_c=5, mid_d=5)
        else:
            self.set (has_head=0)
            #self.set (has_mid=0)
            
    def attach (self, first, second):
        #handles[0] correspond  la tte (destination)
        first.connect_handle (self.handles[1])
        second.connect_handle (self.handles[0])
        self.request_update()

    def get_first_node (self):
        return self._first_node

    def get_second_node (self):
        return self._second_node


    ##Les vnements :
    
#     def on_update (self,  affine):
#         dia.CanvasEdge.on_update (self, affine)
#         for shape in self._shapes:
#             shape.request_update ()

#     def on_get_shape_iter (self):
#         return 0
#         return dia.CanvasEdge.on_get_shape_iter (self)

#     def on_shape_next (self, iter):
#         if iter < len (self._shapes) - 1:
#             return iter + 1
#         else:
#             return dia.CanvasEdge.on_shape_next(self, iter)     

#     def on_shape_value (self, iter):
#         if iter is None:
#             return dia.CanvasEdge.on_shape_value (self, iter)
#         else:
#             return self._shapes[iter]

#     def on_point (self, x, y):
# 	return dia.CanvasEdge.on_point (self, x, y)

#     def on_move (self, x, y, interactive):
# 	return dia.CanvasEdge.on_move (self, x, y, interactive);

#     def on_handle_motion (self, handle, wx, wy, mask):
#         return dia.CanvasEdge.on_handle_motion (self, handle,
#                                                 wx, wy, mask);

#     def on_glue (self, handle, wx, wy):
# 	return dia.CanvasEdge.on_glue (self, handle, wx, wy);

#     # pour CanvasGroupable
#     def on_groupable_add (self, item):
# 	'''Utilis par les enfants durant la construction.'''
# 	return 0

#     def on_groupable_remove (self, item):
#         pass

#     def on_groupable_get_iter (self):
#         return None

#     def on_groupable_next (self, iter):
#         return None

#     def on_groupable_value (self, iter):
#         return iter

#     def on_groupable_length (self):
#         return 1

#     def on_groupable_pos (self, item):
#         if item == self.text:
# 	    return 0
# 	else:
# 	    return -1

gobject.type_register (VcEdge)
dia.set_callbacks (VcEdge)
dia.set_groupable (VcEdge)
