#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from xml.dom import minidom
import os

mods={}
    

#sauvegarde le graphe dans un fichier xml
#PRENDRE GARDE A SAUVEGARDER LES DONNEES SOUS FORME DE CHAINE
#SINON TOPRETTYXML NE FONCTIONNERA PAS (meme si le dom s'est bien construit)
def to_file(filename, graph):
    #creation du document, la chaine graphxml est le tagname de l'element racine
    doc=minidom.DOMImplementation.createDocument(minidom.getDOMImplementation(),
                                                 None,
                                                 'GraphXML',
                                                 None)
    #recuperation de la racine
    root = doc.documentElement
    #on ajoute le graphe a la racine
    graphRoot = doc.createElement('graph')
    graphRoot.setAttribute('class', graph.__class__.__name__)
    root.appendChild(graphRoot)
    
    #1 phase on sauve les attributs ajouts dans la racine du graphe 
    for graph_attr_key in graph.__dict__.keys():
        if userkey(graph_attr_key):
            xml_att_elt=doc.createElement('UserAttr')
            xml_att_elt.setAttribute('key',graph_attr_key)
            xml_att_elt.setAttribute('type',type(graph.__dict__[graph_attr_key]).__name__)
            xml_att_elt.setAttribute('value',str(graph.__dict__[graph_attr_key]))
            graphRoot.appendChild(xml_att_elt)

    #2 phase, on sauve chaque noeud avec tous ses attributs
    for node_key in graph._nodes.keys():
        cur_node=graph._nodes[node_key]
        xml_node_elt=doc.createElement('node')
        #ces lignes concernent la sauvegarde des attributs obligatoires
        #connus a priori
        xml_node_elt.setAttribute('class',cur_node.__class__.__name__)
        xml_node_elt.setAttribute('name',cur_node._name)            
        xml_node_elt.setAttribute('xpos',str(cur_node.affine[4]))
        xml_node_elt.setAttribute('ypos',str(cur_node.affine[5]))
        #cette boucle concerne la sauvegarde des attributs utilisateur (d'une extension)
        for node_attr_key in cur_node.__dict__.keys():
            if userkey(node_attr_key):
                xml_att_elt=doc.createElement('UserAttr')
                xml_att_elt.setAttribute('key',node_attr_key)
                xml_att_elt.setAttribute('type',type(cur_node.__dict__[node_attr_key]).__name__)
                xml_att_elt.setAttribute('value',str(cur_node.__dict__[node_attr_key]))
                xml_node_elt.appendChild(xml_att_elt)
        graphRoot.appendChild(xml_node_elt)

    #pareil pour les edges
    for edge_key in graph._arcs.keys():
        cur_edge=graph._arcs[edge_key]
        xml_edge_elt=doc.createElement('edge')
        #ces lignes concernent la sauvegarde des attributs obligatoires
        #connus a priori
        xml_edge_elt.setAttribute('class',cur_edge.__class__.__name__)
        xml_edge_elt.setAttribute('source',cur_edge._first_node._name)
        xml_edge_elt.setAttribute('target',cur_edge._second_node._name)
        #cette boucle concerne la sauvegarde des attributs utilisateur (d'une extension)
        for edge_attr_key in cur_edge.__dict__.keys():
            if userkey(edge_attr_key):
                xml_att_elt=doc.createElement('UserAttr')
                xml_att_elt.setAttribute('key',edge_attr_key)
                xml_att_elt.setAttribute('type',type(cur_edge.__dict__[edge_attr_key]).__name__)
                xml_att_elt.setAttribute('value',str(cur_edge.__dict__[edge_attr_key]))
                xml_edge_elt.appendChild(xml_att_elt)
        graphRoot.appendChild(xml_edge_elt)
            
    #sauvegarde du fichier
    file=open(filename,'w')
    file.write(doc.toprettyxml())
        





#reconstruction d'un graphe a partir d'un document
#c'est from_doc et pas from_file parce que le gui a deja du appeller parse(nomfichier)
#pour extraire le nom de la classe du graphe
def from_file(file_name, modules_path_dict):
    
    doc=minidom.parse(file_name)
    graphRoot=doc.getElementsByTagName('graph')[0]
    graph_class=graphRoot.attributes['class'].value
    #on sauve le repertoire courant
    cur_dir_bkup=os.getcwd()
    #on va dans le rep ou le module contenant la classe graph_class
    #se trouve
    os.chdir(modules_path_dict[graph_class])
    my_import(graph_class)
    graph=eval('mods[\''+graph_class+'\'].'+graph_class+'()')
                
    #on reconstruit les attributs d'extension du graphe
    #les attributs obligatoires ont etes passes au constructeur dans gui
    for xml_attr_elt in get_local_user_attributes(graphRoot):
        curkey=str(xml_attr_elt.attributes['key'].value)
        curval=xml_attr_elt.attributes['value'].value
        curtype=str(xml_attr_elt.attributes['type'].value)
        graph.__dict__[curkey]=convert(curval,curtype)

    #on reconstruit chaque noeud
    nodes=doc.getElementsByTagName('node')
    for n in nodes:
        #on reconstruit les attributs obligatoires connus a priori
        node_class=str(n.attributes['class'].value)
        node_name=str(n.attributes['name'].value)
        node_xpos=float(n.attributes['xpos'].value)
        node_ypos=float(n.attributes['ypos'].value)
        #on instancie
        #node_to_add=eval(node_class+'(graph,\''+node_name+'\')')
        my_import(node_class)
        node_to_add=eval( 'mods[\''+node_class+'\'].'+node_class+'(graph,\''+node_name+'\')')
        #on retablit les attributs d'extension
        for xml_attr_elt in get_local_user_attributes(n):
            curkey=str(xml_attr_elt.attributes['key'].value)
            curval=xml_attr_elt.attributes['value'].value
            curtype=str(xml_attr_elt.attributes['type'].value)
            node_to_add.__dict__[curkey]=convert(curval,curtype)
        #on place le noeud au bon endroit
        node_to_add.move(node_xpos,node_ypos)
        #on ajoute le noeud au graphe
        graph.add_node(node_to_add)
        
        
    #pareil pour les edges
    edges=doc.getElementsByTagName('edge')
    for e in edges:
        #on construit les donnees indispensables a la creation
        edge_class=str(e.attributes['class'].value)
        edge_source=str(e.attributes['source'].value)
        edge_target=str(e.attributes['target'].value)
        src_node= graph._nodes[edge_source]
        tgt_node= graph._nodes[edge_target]
        #on instancie
        #edge_to_add=eval(edge_class+'.'+edge_class+'( src_node,tgt_node)')
        my_import(edge_class)
        edge_to_add=eval( 'mods[\''+edge_class+'\'].'+edge_class+'(graph)')
            
        #on retablit les attributs d'extension
        for xml_attr_elt in get_local_user_attributes(e):
            curkey=str(xml_attr_elt.attributes['key'].value)
            curval=xml_attr_elt.attributes['value'].value
            curtype=str(xml_attr_elt.attributes['type'].value)
            edge_to_add.__dict__[curkey]=convert(curval,curtype)
                 
        #on ajoute l'arette au graphe
        graph.add_arc(edge_to_add)
        #on connecte l'arete aux sommets 
        edge_to_add.attach(src_node,tgt_node)

    #on met  jour le graphe
    graph.update_now ()
    #on revient la ou on etait
    os.chdir(cur_dir_bkup)
    return graph

             
def my_import(mod_str):
    if (not(is_imported(mod_str))):
        exec('import '+mod_str)
        mods[mod_str]=eval(mod_str)
        
def is_imported(mod_str):
    try:
        mods[key]
        return True
    except:
        return False

#indique si une clee de __dict__ represente un attr utilisateur ou non
def userkey(k):
    if (k[0]=='_'):
        return(False)
    else:
        return(True)
    
#convertit la valeur sous forme de chaine en la valeur du bon type
def convert(string_value,string_type):
    return eval(string_type+'(\''+string_value+'\')')

#retourne les noeuds tagues UserAttr appartenant aux enfants directs de dom_element
def get_local_user_attributes(dom_element):
    local_user_attrs=[]
    direct_children=dom_element.childNodes
    for direct_child in direct_children:
        if (direct_child.nodeType==direct_child.ELEMENT_NODE) and (direct_child.tagName=='UserAttr'):
            local_user_attrs.append(direct_child)
    return(local_user_attrs)




    
