#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from Petri_Node import *
import diacanvas as dia
import pango

         
class Transition (Petri_Node):
    def __init__(self, graph, name):
        Petri_Node.__init__(self, graph, name)
        self._validating_places = 0
        self.add_user_method ('Activate', self.activate)

    def init_shapes (self):
        self.set (height = 40, width = 40)
        self._shapes = []
        self._shapes.append (dia.shape.Path ())
        self._shapes[0].rectangle ((13,0),
                                   (27,self.height))
        self._shapes[0].set_fill (1)
        self._shapes[0].set_fill_color (dia.color (250,250,250))        
	self._shapes[0].set_line_width (1)
        self.init_labels ()
             
#    def delete (self):
#        self._validating_places = None
#        Node.delete (self)

    def incr_validating_places (self):
        self._validating_places = self._validating_places + 1

    def decr_validating_places (self):
        self._validating_places = self._validating_places - 1
        
    def is_validated (self):
        return self._validating_places

    def activate (self):
        for place in self.get_predecessors ():
            if place.get_tokens () > 0:
                place.decr_tokens ()
                place.request_update ()
                if place.get_tokens () == 0:
                    self.decr_validating_places ()
                           
        for place in self.get_successors ():
            if place.get_tokens () == 0:
                for trans in place.get_successors ():
                    trans.incr_validating_places ()
            place.incr_tokens ()
            place.request_update ()
  
            
