#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
from Arc import *
from Place import *
from Transition import *


class Petri_Arc (Arc):

    def __init__(self, graph):
        Arc.__init__(self, graph)

    def __del__(self):
        print "finalisation PETRIARC"
        Arc.__del__(self)

    def attach (self, first, second):
        if type(first) is type (second):
            raise EdgeError ("Two nodes of the same type cannot be bound")

        if type (first) is Place:
            if (first.get_tokens > 0):
                second.incr_validating_places ()

        Arc.attach (self, first, second)
        self._graph.number_nodes (self)
        self._graph.update_all_labels ()
        print "attachement PETRIARC"
        
    def delete (self):
        #si first_node est une place qui possde plusieurs jetons,
        #alors dcrmenter le nombre de places validantes  
        #dans le noeud transition que l'edge lui associe 
        if (type(self._first_node) is Place) and \
               (self._first_node.get_tokens > 0):
            self._second_node.decr_validating_places ()
        print "dltion PETRIARC"
        Arc.delete(self)
