#
# $Id$
#
# This file is part of GraphTool.
#
# GraphTool is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GraphTool is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GraphTool; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
import diacanvas as dia
from Node import *
from Arc import *
import interactive as inter

class Graph (dia.Canvas, inter.Interactive):
    def __init__(self):
        dia.Canvas.__init__ (self)
        inter.Interactive.__init__ (self)
        self.set_property ('allow_undo', 0)
        self.set_property ('static_extents', 1)
        self.set_property ('grid_color', dia.color (255,255,255))

        self._counter_name = 1
        self._arcs = {}
        self._nodes = {}
        self._global_constraints = []
        self._nodes_constraints = []
        self._arcs_constraints = []

    def __del__ (self):
        print "Graph finalis"

    #pour finaliser le graphe (permettre le travail du GC)
    def delete (self):
        for knode in self._nodes.keys():
            self._nodes[knode].delete ()

    ##Manipulation des Noeuds/Arcs
            
    def get_nodes (self):
        return self._nodes

    def get_arcs (self):
        return self._arcs
    
    def make_node (self):
        name = str (self._counter_name)
        new_node = Node (self, name)
        self._counter_name = self._counter_name + 1
        self.add_node (new_node)
        return new_node

    def add_node (self, node):
        self.root.add (node)
        self._nodes [node.get_name()] = node

    def make_arc (self):
        new_arc = Arc (self)
        self.add_arc (new_arc)
        return new_arc

    def add_arc (self, arc):
        #L'arc est dans le graph, mais pas dans le canvas
        #avant 'attach'
        self._arcs [id (arc)] = arc

    def remove_node (self, node):
        self.root.remove (node)
        del self._nodes[node.get_name ()]
        
    def remove_arc (self, arc):
        del self._arcs[id (arc)]

    def foreach_node (self, func, *params):
        for nk in self._nodes:
            func (self._nodes [nk], params)

    def foreach_arc (self, func, *params):
        for ak in self._arcs:
            func (self._arcs [ak], params)
            

    ##TOOLBAR
    ##-------
    def get_toolbar (self):
        return [['IN','add_node.png',self.make_node],
                ['IE','add_arc.png',self.make_arc]]


    ##Mthodes 'visuelles'
    def get_interactive_methods (self):
        return [["get-nodes", self.get_nodes]]

    ##CONTRAINTES
    ##------------
    ##Ajout d'une contrainte. Elle peut tre nomme ou non.
    ##Elle peut tre de 3 types : global, node ou arc

    def add_global_constraint (self, func_name, const_name = None):
        self._global_constraints.append (constraint_name, function_name)    

    def add_node_constraints (self, func_name, const_name = None):
        self._node_constraints.append (constraint_name, function_name)

    def add_arc_constraint (self, func_name, const_name = None):
        self._arc_constraints.append (constraint_name, function_name)


    ##Vrification d'une contrainte particulire nomme
    def check_arc_constraint (self,constraint_name,
                              function_parameters):
        constraints_list = self._arcs_constraints
        check_constraint (constraints_list, constraint_name,
                          function_parameters)

    def check_node_constraint (self, constraint_name,
                               function_parameters):
        constraints_list = self._nodes_constraints
        check_constraint (constraints_list, constraint_name,
                          function_parameters)
        
    def check_global_constraint (self, constraint_name,
                                 function_parameters):

        constraints_list = self._global_constraints
        check_constraint (constraints_list, constraint_name,
                          function_parameters)
       
    def check_constraint (constraints_list,
                          constraint_name,
                          function_parameters):
        i = 0
        size = len (constraints_list)
        while (i < size) and (constraint[0] <= constraint_name):
            constraint = constraints_list[i]
            if (constraint[0] == constraint_name):
                constraint_function = constraint[1]
                check_return = apply (constraint_function,
                                      (function_parameters,))
                return check_return
            i = i + 1

        ##La contrainte n'a pas t trouve
        raise ConstraintError ("Constraint not found")
        
                    
    ##Vrification de l'ensemble des contraintes d'un mme type
    def check_constraints (self, type_constraint,
                           function_parameters = None):
        if (type_constraint is 'GLOBAL'):
            constraints_list = self._global_constraints
        elif (type_constraint is 'NODE'):
            constraints_list = self._nodes_constraints
        elif (type_constraint is 'ARC'):
            constraints_list = self._arcs_constraints
        else:
            raise ConstraintError ("Invalid constraint type ")

        for x in constraints_list:
            constraint_function = x[1]
            check_return = apply (constraint_function,(function_parameters,)) 
            if (not (check_return)):
                return 0
        return 1

class ConstraintError (Exception):
    def __init__(self, msg):
        self.msg = msg

    def get_msg (self):
        return self.msg
    
    
def add_toolbar_item (tb, name, picture, function):
    new_entry = [name, picture, function]
    tb.append (new_entry)
    return tb

def remove_toolbar_item (tb, name):
    i = 0
    while (tb[i][0] != name):
        i = i + 1
    del tb[i]
    return tb

def replace_toolbar_item (tb, name, picture, function):
    i = 0
    while (tb[i][0] != name):
        i = i + 1
    tb[i] = [name, picture, function]
    return tb




