/* matrices.h

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   See the GNU General Public License at <http://www.gnu.org/licenses/> 

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

*/

#ifndef MATRICES_H_DEFINED


/* ----------------------------------------------------------------------------
   Constants
*/

#define TINY  1.0e-20


/* ----------------------------------------------------------------------------
   Prototypes
*/

void   CopydMatrix (double **from, long dim1, long dim2, double **to);

double **InitdMatrix (long dim1, long dim2);
int    **InitiMatrix (long dim1, long dim2);

double *InitdVector (long dim);
int    *InitiVector (long dim);

void   PrintdMatrix (FILE *pFile, int dim, double **pdMat);
void   PrintiMatrix (FILE *pFile, int dim, int **piMat);
void   PrintSortediMatrix (FILE *pFile, int dim, int **piMat, int *pindex);

void   InvertMatrix (double **M, int dim);

double Determinant_LU       (double **M, int dim);
double LnDeterminant_LU     (double **M, int dim);
double LnDeterminant_LU_gsl (double **M, int dim);
double LnDeterminant_Chol   (double **M, int dim);


/* ----------------------------------------------------------------------------
   Global declarations
*/

extern double **pdWorkMatrixSizeN; // need to be defined, inited and freed
                                   // by the caller


/* End */

#define MATRICES_H_DEFINED
#endif  /* _MATRICES_H_ */

