/* likelihoods.h

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   See the GNU General Public License at <http://www.gnu.org/licenses/> 

   -- Revisions -----
     Logfile:  %F%
    Revision:  %I%
        Date:  %G%
     Modtime:  %U%
      Author:  @a
   -- SCCS  ---------

*/

#ifndef LIKELIHOODS_H_DEFINED


/* ----------------------------------------------------------------------------
   Type definitions
*/

#ifndef TRUE
typedef int BOOL;
#define TRUE  1
#define FALSE 0
#endif


/* ----------------------------------------------------------------------------
   Prototypes
*/

void   Loglikelihood_diff (int parent, int child, int diff,
                           double **pData, double *logLdiff);
double Loglikelihood_full (int N, double **pData);

double GLoglikelihood_node        (int node, double **pData);
double GLoglikelihood_node_DBN    (int node, double **pData);
double GPostPredictiveSample_node (int node, double **pData, 
                                   double *pSamples);

double DLoglikelihood_node        (int node, double **pData);
double DLoglikelihood_node_DBN    (int node, double **pData);

double ZLoglikelihood_node        (int node, double **pData);
double ZLoglikelihood_node_DBN    (int node, double **pData);

void sort(long n, double *vect);


/* ----------------------------------------------------------------------------
   Global declarations
*/

// externals, to be defined elsewhere

extern BOOL   bBN;                 // sample Bayesian networks
extern int    nNodes;              // the number of nodes in graph
extern int    *nParents;           // number of parents for each node
extern int    **index_parents;     // the list of current parents for each node
extern BOOL   *bAllowed_parents;   // Boolean: are parents allowed for each node
extern double *current_ll_node;    // likelihoods for each node
extern BOOL   bNormalGamma;        // Normal-Gamma score on or off
extern BOOL   bDirichlet;          // Dirichlet score on or off
extern BOOL   bZellner;            // Zellner score on or off
extern double alpha_normal_gamma;  // prior Gamma shape for data precision
extern double beta_normal_gamma;   // prior Gamma rate for data precision
extern double gamma_zellner;       // tuning parameter for Zellner score
extern int    nData;               // max number of data points per node
extern int    *pDataLevels;        // number of codes per node for discrete data
extern BOOL   bNAData;             // flag for missing data in data matrix


/* End */

#define LIKELIHOODS_H_DEFINED
#endif  /* LIKELIHOODS_H_DEFINED */

