/* graph_sampler lexical parser

   Written by Frederic Bois
   22 June 2014

   Copyright (c) 2014 Frederic Bois.

   This code is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
   For more details
   see the GNU General Public License at <http://www.gnu.org/licenses/> 
*/

/* Prologue */
%{
#include <stdlib.h>
#include "y.tab.h"
void yyerror(const char *message);
int lineno = 1;
%}

DIGIT    [0-9]
ID       [A-Za-z][A-Za-z0-9_]*
COMMENT  #.* 
LCB      \{
RCB      \}
LPAR     \(
RPAR     \)

/* Rules */
%%

alpha_motif                  { return alpha_motif_id; }
autocycle                    { return autocycle_id; }

bayesian_network             { return bBN_id; }
bBN                          { return bBN_id; }

beta_motif                   { return beta_motif_id; }

concordance_prior            { return bPriorConcordance_id; }
bPriorConcordance            { return bPriorConcordance_id; }

degree_prior                 { return bPriorDegreeNode_id; }
bPriorDegreeNode             { return bPriorDegreeNode_id; }

dynamic_bayesian_network     { return bDBN_id; }

gamma_degree                 { return gamma_degree_id; }

lambda_concordance           { return lambda_concord_id; }
lambda_concord               { return lambda_concord_id; }

motif_prior                  { return bPriorMotif_id; }
bPriorMotif                  { return bPriorMotif_id; }

n_burnin                     { return nBurnin_id; }
nBurnin                      { return nBurnin_id; }

n_data                       { return nData_id; }
nData                        { return nData_id; }

n_data_levels                { return nLevels_id; }
nData_levels                 { return nLevels_id; }

n_nodes                      { return nNodes_id; }
nNodes                       { return nNodes_id; }

n_runs                       { return nRuns_id; }
nRuns                        { return nRuns_id; }

nSaved_adjacency             { return n_saved_adjacency_id; }
n_saved_adjacency            { return n_saved_adjacency_id; }

random_seed                  { return seed_id; }
seed                         { return seed_id; }

save_best_graph              { return bsave_best_graph_id; }
bsave_best_graph             { return bsave_best_graph_id; }

save_degree_counts           { return bsave_the_degree_counts_id; }
bsave_the_degree_counts      { return bsave_the_degree_counts_id; }

save_edge_probabilies        { return bsave_the_edge_probabilies_id; }
bsave_the_edge_probabilies   { return bsave_the_edge_probabilies_id; }

save_motifs_probabilies      { return bsave_the_motifs_probabilies_id; }
bsave_the_motifs_probabilies { return bsave_the_motifs_probabilies_id; }

save_chain                   { return bsave_the_chain_id; }
bsave_the_chain              { return bsave_the_chain_id; }

dirichlet_score              { return bDirichlet_id; }
bDirichlet                   { return bDirichlet_id; }

zellner_score                { return bZellner_id; }
bZellner                     { return bZellner_id; }

data                         { return Data_id; }
edge_requirements            { return edge_requirements_id; }
hyper_pB                     { return hyper_pB_id; }
initial_adjacency            { return initial_adjacency_id; }

array       { return ARRAY; }

matrix      { return MATRIX; }

empty       { return EMPTY; }

full        { return FULL; }

random      { return RANDOM; }

true|TRUE   { yylval.ival = 1; return INTEGER; }

false|FALSE { yylval.ival = 0; return INTEGER; }

{DIGIT}+  { yylval.ival = atol(yytext);
            return INTEGER; }

[0-9]+"."[0-9]* |
      "."[0-9]* |
         [0-9]+[eE][+-]?[0-9]+ |
[0-9]+"."[0-9]*[eE][+-]?[0-9]+ |
      "."[0-9]*[eE][+-]?[0-9]+	{ yylval.dval = atof(yytext); return FLOAT; }

^[\n]     { lineno++; } // skip but count

[\n]      { lineno++; } // skip but count

[-+=*/\;] { return *yytext; }

{LCB}     { return L_CBRACE; }

{RCB}     { return R_CBRACE; }

{LPAR}    { return L_PARENTHESIS; }

{RPAR}    { return R_PARENTHESIS; }

[ \t]+    { ; } /* skip whitespace */

{COMMENT} { ; } /* skip comments */

{ID}      { yylval.ivarnum = *yytext; 
            printf("-> temporary variable: %s\n", yytext);
            return IDENTIFIER; }

.         { return *yytext; } /* let yacc take care of the junk */


%% /* Epilogue */

int yywrap(void) {
  return 1;
}

/* ----------------------------------------------------------------------------
   yyerror
*/
void yyerror(const char *message) {
  fprintf(stderr, "Error, line %d: %s near '%s' - Exiting.\n\n", lineno, message, yytext); 
  exit(0);
}


/* End. */