/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_PERSONALNAMEPARSER_DECL_H_
#define _GEDCOMPARSER_PERSONALNAMEPARSER_DECL_H_
#include <stdio.h>

#define	yymaxdepth personalname_maxdepth
#define	yyparse	personalname_parse
#define	yyerror	personalname_error
#define	yylval	personalname_lval
#define	yychar	personalname_char
#define	yydebug	personalname_debug
#define	yypact	personalname_pact	
#define	yyr1	personalname_r1			
#define	yyr2	personalname_r2			
#define	yydef	personalname_def		
#define	yychk	personalname_chk		
#define	yypgo	personalname_pgo		
#define	yyact	personalname_act		
#define	yyexca	personalname_exca
#define yyerrflag personalname_errflag
#define yynerrs	personalname_nerrs
#define	yyps	personalname_ps
#define	yypv	personalname_pv
#define	yys	personalname_s
#define	yy_yys	personalname_yys
#define	yystate	personalname_state
#define	yytmp	personalname_tmp
#define	yyv	personalname_v
#define	yy_yyv	personalname_yyv
#define	yyval	personalname_val
#define	yylloc	personalname_lloc
#define yyreds	personalname_reds
#define yytoks	personalname_toks
#define yylhs	personalname_yylhs
#define yylen	personalname_yylen
#define yydefred personalname_yydefred
#define yydgoto	personalname_yydgoto
#define yysindex personalname_yysindex
#define yyrindex personalname_yyrindex
#define yygindex personalname_yygindex
#define yytable	 personalname_yytable
#define yycheck	 personalname_yycheck

#include <string>

#define YYSTYPE char *

struct yy_buffer_state * personalname_scan_string(const char *);
void personalname_runparse(std::string const &);
std::string get_given_name(void);
std::string get_surname(void);
#endif
