#ifndef _GEDCOMPARSER_VISITOR_GEDCOMSERIALIZERVISITOR_HH_
#define _GEDCOMPARSER_VISITOR_GEDCOMSERIALIZERVISITOR_HH_

#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/Serializer/Serializable.hh"

///
namespace GEDCOMParser
{
  class GEDCOMSerializerVisitor:public GEDCOMParser::GEDCOMVisitor,
    ///
    public GEDCOMParser::Serializable
  {
  public:
    virtual void VisitAddress (GEDCOMParser::Address *);
    virtual void VisitAssociation (GEDCOMParser::Association *);
    virtual void VisitChangeDate (GEDCOMParser::ChangeDate *);
    virtual void VisitChildToFamilyLink (GEDCOMParser::ChildToFamilyLink *);
    virtual void VisitData (GEDCOMParser::Data *);
    virtual void VisitEvent (GEDCOMParser::Event *);
    virtual void VisitFamilyEvent (GEDCOMParser::FamilyEvent *);
    virtual void VisitFamilyRecord (GEDCOMParser::FamilyRecord *);
    virtual void VisitHeader (GEDCOMParser::Header *);
    virtual void VisitIndividualAttribute (GEDCOMParser::
					   IndividualAttribute *);
    virtual void VisitIndividualEvent (GEDCOMParser::IndividualEvent *);
    virtual void VisitIndividualRecord (GEDCOMParser::IndividualRecord *);
    virtual void VisitLdsIndividualOrdinance (GEDCOMParser::
					      LdsIndividualOrdinance *);
    virtual void VisitLdsSpouseSealing (GEDCOMParser::LdsSpouseSealing *);
    virtual void VisitLineageLinkageGedcom (GEDCOMParser::
					    LineageLinkageGedcom *);
    virtual void VisitMultimediaLink (GEDCOMParser::MultimediaLink *);
    virtual void VisitMultimediaRecord (GEDCOMParser::MultimediaRecord *);
    virtual void VisitNoteRecord (GEDCOMParser::NoteRecord *);
    virtual void VisitNoteStructure (GEDCOMParser::NoteStructure *);
    virtual void VisitPersonalName (GEDCOMParser::PersonalName *);
    virtual void VisitPlace (GEDCOMParser::Place *);
    virtual void VisitRepositoryRecord (GEDCOMParser::RepositoryRecord *);
    virtual void VisitSourceCitation (GEDCOMParser::SourceCitation *);
    virtual void VisitSourceRecord (GEDCOMParser::SourceRecord *);

    virtual void VisitSourceRecordData (GEDCOMParser::SourceRecord::Data *);
    virtual void VisitSourceRecordDataEvent (GEDCOMParser::SourceRecord::
					     Data::Event *);

    virtual void VisitSourceRepositoryCitation (GEDCOMParser::
						SourceRepositoryCitation *);
    virtual void VisitSourceRepositoryCitationSourceCallNumber (GEDCOMParser::
								SourceRepositoryCitation::
								SourceCallNumber
								*);
    virtual void VisitSpouseToFamilyLink (GEDCOMParser::SpouseToFamilyLink *);
    virtual void VisitSubmission (GEDCOMParser::Submission *);
    virtual void VisitSubmitterRecord (GEDCOMParser::SubmitterRecord *);
    virtual void VisitUserReference (GEDCOMParser::UserReference *);

    virtual void VisitFamilyRecords (GEDCOMParser::FamilyRecords_t *);
    virtual void VisitIndividualRecords (GEDCOMParser::IndividualRecords_t *);
    virtual void VisitMultimediaRecords (GEDCOMParser::MultimediaRecords_t *);
    virtual void VisitNoteRecords (GEDCOMParser::NoteRecords_t *);
    virtual void VisitRepositoryRecords (GEDCOMParser::RepositoryRecords_t *);
    virtual void VisitSourceRecords (GEDCOMParser::SourceRecords_t *);
    virtual void VisitSourceRecordDataEvents (GEDCOMParser::SourceRecord::
					      Data::Events_t *);
    virtual void VisitSubmitterRecords (GEDCOMParser::SubmitterRecords_t *);
    virtual void VisitAssociations (GEDCOMParser::Associations_t *);
    virtual void VisitChildToFamilyLinks (GEDCOMParser::
					  ChildToFamilyLinks_t *);
    virtual void VisitFamilyEvents (GEDCOMParser::FamilyEvents_t *);
    virtual void VisitIndividualAttributes (GEDCOMParser::
					    IndividualAttributes_t *);
    virtual void VisitIndividualEvents (GEDCOMParser::IndividualEvents_t *);
    virtual void VisitLdsIndividualOrdinances (GEDCOMParser::
					       LdsIndividualOrdinances_t *);
    virtual void VisitLdsSpouseSealings (GEDCOMParser::LdsSpouseSealings_t *);
    virtual void VisitMultimediaLinks (GEDCOMParser::AttachmentManager::
				       MultimediaLinks_t *);
    virtual void VisitNoteStructures (GEDCOMParser::AttachmentManager::
				      NoteStructures_t *);
    virtual void VisitPersonalNames (GEDCOMParser::PersonalNames_t *);
    virtual void VisitSourceCitations (GEDCOMParser::AttachmentManager::
				       SourceCitations_t *);
    virtual void VisitEvents (GEDCOMParser::SourceRecord::Data::Events_t *);
    virtual void VisitSourceCallNumbers (GEDCOMParser::
					 SourceRepositoryCitation::
					 SourceCallNumbers_t *);
    virtual void VisitSpouseToFamilyLinks (GEDCOMParser::
					   SpouseToFamilyLinks_t *);
    virtual void VisitUserReferences (GEDCOMParser::UserReferences_t *);


  private:
    int _ref_level;
  };
};

#endif
