/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_USER_REFERENCE_HH_
#define _GEDCOMPARSER_USER_REFERENCE_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the USER REFERENCE members of many structures in the GEDCOM 5.5 specifications (for instance INDIVIDUAL_RECORD)
  class UserReference:public GEDCOMElement
  {
  protected:
    ///
    std::string _number;
    ///
    std::string _type;
  public:
    ///
    virtual ~ UserReference (void)
    {
    };
    ///@name Accessors (set) 
    //@{    
    ///   
    void setNumber (std::string const &);
    ///   
    void setType (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    ///   
    virtual std::string const &getNumber (void) const;
    ///   
    virtual std::string const &getType (void) const;
    //@}  
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
  ///@name typedefs
  //@{
  /// @doc handling of many user references
  typedef std::vector < SmartPtr < UserReference > >UserReferences_t;
  //@}

};
#endif
