/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "Submission.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"

void
GEDCOMParser::Submission::setId (std::string const &value)
{
  _id = value;
  return;
}

void
GEDCOMParser::Submission::setSubmXref (std::string const &value)
{
  _subm_xref = value;
  return;
}

void
GEDCOMParser::Submission::setFamf (std::string const &value)
{
  _famf = value;
  return;
}

void
GEDCOMParser::Submission::setTemp (std::string const &value)
{
  _gedc_temp = value;
  return;
}

void
GEDCOMParser::Submission::setAnce (std::string const &value)
{
  _ance = value;
  return;
}

void
GEDCOMParser::Submission::setDesc (std::string const &value)
{
  _desc = value;
  return;
}

void
GEDCOMParser::Submission::setOrdi (std::string const &value)
{
  _ordi = value;
  return;
}

void
GEDCOMParser::Submission::setRin (std::string const &value)
{
  _rin = value;
  return;
}


std::string const &
GEDCOMParser::Submission::getId (void) const
{
  return _id;
}

std::string const &
GEDCOMParser::Submission::getSubmXref (void) const
{
  return _subm_xref;
}

std::string const &
GEDCOMParser::Submission::getFamf (void) const
{
  return _famf;
}

std::string const &
GEDCOMParser::Submission::getTemp (void) const
{
  return _gedc_temp;
}

std::string const &
GEDCOMParser::Submission::getAnce (void) const
{
  return _ance;
}

std::string const &
GEDCOMParser::Submission::getDesc (void) const
{
  return _desc;
}

std::string const &
GEDCOMParser::Submission::getOrdi (void) const
{
  return _ordi;
}

std::string const &
GEDCOMParser::Submission::getRin (void) const
{
  return _rin;
}

void
GEDCOMParser::Submission::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitSubmission (this);
  return;
}
