/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_SPOUSE_TO_FAMILY_LINK_HH_
#define _GEDCOMPARSER_SPOUSE_TO_FAMILY_LINK_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/FamilyLink.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 SPOUSE_TO_FAMILY_LINK structure
  class SpouseToFamilyLink:public FamilyLink
  {
  public:
    ///
    virtual ~ SpouseToFamilyLink (void)
    {
    };
    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
    ///
    class IsEqualByFamXref
    {
    public:
      ///
      IsEqualByFamXref (std::string const &xref):_xref (xref)
      {
      };
        ///
        std::string _xref;
      ///
      bool operator      () (SmartPtr < GEDCOMParser::SpouseToFamilyLink >
			     const &link)
      {
	return _xref == link->getFamXref ();
      };
    };

  };
  ///@name typedefs
  //@{
  /// @doc handling of many spouse to family links
  typedef std::vector < SmartPtr < SpouseToFamilyLink >
    >SpouseToFamilyLinks_t;
  //@}
};
#endif
