/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_SOURCEREPOSITORYCITATION_HH_
#define _GEDCOMPARSER_SOURCEREPOSITORYCITATION_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 SOURCE_REPOSITORY_CITATION structure
  class SourceRepositoryCitation:public GEDCOMElement,
    ///
    public AttachmentManager
  {
  public:
    /// @memo Implements the SOURCE_CALL_NUMBER members of the SOURCE_REPOSITORY_CITATION structure
    class SourceCallNumber:public GEDCOMElement
    {
    public:
      virtual ~ SourceCallNumber (void)
      {
      };
      ///@name Accessors (set) 
      //@{    
      ///     
      void setCallNumber (std::string const &);
      ///     
      void setMedi (std::string const &);
      //@}

      ///@name Accessors (get)
      //@{    
      ///      
      virtual std::string const &getCallNumber (void) const;
      ///      
      virtual std::string const &getMedi (void) const;
      virtual void Accept (GEDCOMParser::GEDCOMVisitor *);

      //@}     
    protected:
        std::string _caln;
        std::string _medi;
    };
    ///@name typedefs
    //@{
    /// @doc handling of many source call numbers
    typedef std::vector < SmartPtr < SourceCallNumber > >SourceCallNumbers_t;
    //@}
    virtual ~ SourceRepositoryCitation (void)
    {
    };
    ///@name Accessors (set) 
    //@{    
    ///    
    void setRepoXref (std::string const &);
    ///
    GEDCOMParser::SourceRepositoryCitation::SourceCallNumber *
      addSourceCallNumber (SourceRepositoryCitation::SourceCallNumber *
			   const data = 0);
    //@}

    ///@name Accessors (get)
    //@{    
    ///
    virtual std::string const &getRepoXref (void) const;
    ///
    SourceCallNumbers_t const &getSourceCallNumbers (void) const;
    //@} 
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
    std::string _repo_xref;
    SourceCallNumbers_t _call_numbers;
  };
};
#endif
