/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_SOURCE_CITATION_HH_
#define _GEDCOMPARSER_SOURCE_CITATION_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  ///
  class SourceCitation;
  ///@name typedefs
  //@{
  /// @doc handling of many source citations
  typedef std::vector < SmartPtr < SourceCitation > >SourceCitations_t;
  //@}
};

#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Attachment.hh"

///
namespace GEDCOMParser
{
  /// @memo Implements the GEDCOM 5.5 SOURCE_CITATION structure   
  class SourceCitation:public GEDCOMElement,
    ///
    public Attachment, public AttachmentManager
  {
  protected:
    std::string _source_xref;
    std::string _page;
    std::string _event;
    std::string _event_role;
    GEDCOMParser::DateManagement::DateValue * _data_date;
    std::string _data_text;
    std::string _quay;
    std::string _description;
    std::string _text;
  public:
    SourceCitation (void):_source_xref (),
      _page (),
      _event (),
      _event_role (),
      _data_date (0), _data_text (), _quay (), _description (), _text ()
    {
      return;
    };
      SourceCitation (SourceCitation const &s):_source_xref (s._source_xref),
      _page (s._page),
      _event (s._event),
      _event_role (s._event_role),
      _data_date (0),
      _data_text (s._data_text),
      _quay (s._quay), _description (s._description), _text (s._text)
    {
      if (s._data_date != 0)
	{
	  _data_date =
	    new GEDCOMParser::DateManagement::DateValue (*s._data_date);
	}
      return;
    };

    virtual ~ SourceCitation (void)
    {
      delete _data_date;
      _data_date = 0;
      return;
    }


    ///@name Accessors (set) 
    //@{    
    ///
    void setSourceXref (std::string const &);
    ///
    void setPage (std::string const &);
    ///
    void setEvent (std::string const &);
    ///
    void setEventRole (std::string const &);
    ///
    void setDataDate (std::string const &);
    ///
    void concDataText (std::string const &);
    ///
    void contDataText (std::string const &);
    ///
    void setQuay (std::string const &);
    ///
    void concDescription (std::string const &);
    ///
    void contDescription (std::string const &);
    ///
    void concText (std::string const &);
    ///
    void contText (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{   
    ///
    virtual std::string const &getSourceXref (void) const;
    ///
    virtual std::string const &getPage (void) const;
    ///
    virtual std::string const &getEvent (void) const;
    ///
    virtual std::string const &getEventRole (void) const;
    ///
    virtual std::string const getDataDate (void) const;
    ///
    virtual GEDCOMParser::DateManagement::DateValue const * const getDataDateObject(void) const;
    ///
    virtual std::string const &getDataText (void) const;
    ///
    virtual std::string const &getQuay (void) const;
    ///
    virtual std::string const &getDescription (void) const;
    ///
    virtual std::string const &getText (void) const;
    //@}
    ///operator == used to find a source citation by its source record xref
    friend bool operator== (SourceCitation const &source_citation,
			    std::string const &source_xref)
    {
      return (source_citation._source_xref == source_xref);
    };
    ///operator == used to find a source citation by its source record xref
    friend bool operator== (SourceCitation * const source_citation,
			    std::string const &source_xref)
    {
      return (source_citation->_source_xref == source_xref);
    };

    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
