#ifndef _GEDCOMPARSER_SERIALIZER_WRITER_HH_
#define _GEDCOMPARSER_SERIALIZER_WRITER_HH_

#include <string>
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"

///
namespace GEDCOMParser
{
  class Serializable;
  ///
  class Writer
  {
  public:
    ///
    virtual void WriteString (std::string const &name,
			      std::string const &value,
			      bool write_blank_value = false) = 0;
    ///
    virtual void WriteStrings (std::string const &name,
			       std::vector < std::string > const &values) = 0;
    ///
    virtual void WriteObject (std::string const &name, Serializable const *) =
      0;
    ///
    virtual void WriteText (std::string const &name, std::string const &value,
			    int ref_level) = 0;
    ///
    virtual void WriteDate (std::string const &name,
			    GEDCOMParser::DateManagement::
			    DateValue const *const value) = 0;
      ///
      std::string getBuffer (void) const;
    ///
    void resetBuffer (void);
  protected:
      ///
      std::string _buffer;
  };
};
#endif
