#ifndef _GEDCOMPARSER_SERIALIZER_GEDCOMWRITER_HH_
#define _GEDCOMPARSER_SERIALIZER_GEDCOMWRITER_HH_

#include "GEDCOMParser/Serializer/Writer.hh"
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"

#include <string>
#include <fstream>

///
namespace GEDCOMParser
{
  ///
  class GEDCOMWriter:public GEDCOMParser::Writer
  {
  public:
    void WriteString (std::string const &name, std::string const &value, bool write_blank_value = false);
    ///
    void WriteStrings (std::string const &name,
		       std::vector < std::string > const &values);
    ///
    void WriteObject (std::string const &name, Serializable const *);
    ///
    void WriteText (std::string const &name, std::string const &value,
		    int ref_level);
    ///
    void WriteDate (std::string const &name,
		    GEDCOMParser::DateManagement::
		    DateValue const *const value);
  private:
  };
};

#endif
