#ifndef _GEDCOMPARSER_PREDICATES_GENERIC_PREDICATE_INDIVIDUALRECORDS__HH_
#define _GEDCOMPARSER_PREDICATES_GENERIC_PREDICATE_INDIVIDUALRECORDS__HH_

#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/Predicates/PredicateIndividualRecords.hh"

namespace GEDCOMParser
{
  namespace Predicates
  {
    template < class Predicate >
      class GenericPredicateIndividualRecords:public GEDCOMParser::
      Predicates::PredicateIndividualRecords
    {
    public:
      GenericPredicateIndividualRecords (Predicate const &p):_predicate (0)
      {
	_predicate = new Predicate (p);
      }
      bool operator      () (GEDCOMParser::
			     IndividualRecords_elem_t const &individu) const
      {
	return (*_predicate) (individu);
      }
    private:
        Predicate const *_predicate;
    };
    template < class Predicate >
      inline GenericPredicateIndividualRecords < Predicate >
      *getGenericPredicateIndividualRecords (Predicate const &p)
    {
      return new GenericPredicateIndividualRecords < Predicate > (p);
    };
  };
};
#endif
