/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "PersonalName.hh"
#include "GEDCOMParser/personalnameparser_decl.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

#define PERSONALNAME_SEPARATOR "/"

void
GEDCOMParser::PersonalName::setName (std::string const &value)
{
  _raw_name = value;
  personalname_runparse (value);
  _givn = get_given_name ();
  _surn = get_surname ();
  _name = _givn + " " + _surn;
  return;
}

void
GEDCOMParser::PersonalName::setNpfx (std::string const &value)
{
  _npfx = value;
  return;
}

void
GEDCOMParser::PersonalName::setGivn (std::string const &value)
{
  _raw_givn = value;
  setName (_raw_givn + PERSONALNAME_SEPARATOR + _surn +
	   PERSONALNAME_SEPARATOR);
  return;
}

void
GEDCOMParser::PersonalName::setNick (std::string const &value)
{
  _nick = value;
  return;
}

void
GEDCOMParser::PersonalName::setSpfx (std::string const &value)
{
  _spfx = value;
  return;
}

void
GEDCOMParser::PersonalName::setSurn (std::string const &value)
{
  _raw_surn = value;
  setName (_givn + PERSONALNAME_SEPARATOR + _raw_surn +
	   PERSONALNAME_SEPARATOR);
  return;
}

void
GEDCOMParser::PersonalName::setNsfx (std::string const &value)
{
  _nsfx = value;
  return;
}

std::string const &
GEDCOMParser::PersonalName::getName (void) const
{
  return _name;
}

std::string const &
GEDCOMParser::PersonalName::getRawName (void) const
{
  return _raw_name;
}

std::string const &
GEDCOMParser::PersonalName::getNpfx (void) const
{
  return _npfx;
}

std::string const &
GEDCOMParser::PersonalName::getGivn (void) const
{
  return _givn;
}

std::string const &
GEDCOMParser::PersonalName::getRawGivn (void) const
{
  return _raw_givn;
}


std::string const &
GEDCOMParser::PersonalName::getNick (void) const
{
  return _nick;
}

std::string const &
GEDCOMParser::PersonalName::getSpfx (void) const
{
  return _spfx;
}

std::string const &
GEDCOMParser::PersonalName::getSurn (void) const
{
  return _surn;
}

std::string const &
GEDCOMParser::PersonalName::getRawSurn (void) const
{
  return _raw_surn;
}

std::string const &
GEDCOMParser::PersonalName::getNsfx (void) const
{
  return _nsfx;
}

void
GEDCOMParser::PersonalName::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitPersonalName (this);
  return;
}
