/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "GEDCOMParser/Parser.hh"
#include "GEDCOMParser/gedcomparser.hh"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gettext.h"

GEDCOMParser::Parser::Parser (GEDCOMParser::GEDCOMFactory const *factory,
			      GEDCOMParser::LineageLinkageGedcom * lineage):
_factory (factory),
_lineage_linkage_gedcom (lineage),
_parse_error_manager (0)
{
  _parse_error_manager =
    new GEDCOMParser::ParseErrorManagement::ParseErrorManager;
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
};

GEDCOMParser::ParseErrorManagement::ParseErrorManager const &
GEDCOMParser::Parser::Parse (std::string const &filename, int debug)
{
  GedcomParse (filename, _lineage_linkage_gedcom, _factory, debug,
	       _parse_error_manager);
  if (_lineage_linkage_gedcom == 0)
    {
      _lineage_linkage_gedcom = get_lineage_linkage_gedcom ();
    }
  return *_parse_error_manager;
}

GEDCOMParser::LineageLinkageGedcom *
  GEDCOMParser::Parser::getLineageLinkageGedcom (void) const
{
  return _lineage_linkage_gedcom;
}
