/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "NoteRecord.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

GEDCOMParser::NoteRecord::NoteRecord (std::string const &id = "")
{
  if (id != "")
    {
      setId (id);
    }
  return;
}

void
GEDCOMParser::NoteRecord::setId (std::string const &value)
{
  _note_id = value;
  return;
}

void
GEDCOMParser::NoteRecord::contSubmitterText (std::string const &value)
{
  _submitter_text = _submitter_text + "\n" + value;
  return;
}

void
GEDCOMParser::NoteRecord::concSubmitterText (std::string const &value)
{
  _submitter_text = _submitter_text + value;
  return;
}

std::string const &
GEDCOMParser::NoteRecord::getId (void) const
{
  return _note_id;
}

std::string const &
GEDCOMParser::NoteRecord::getSubmitterText (void) const
{
  return _submitter_text;
}

void
GEDCOMParser::NoteRecord::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitNoteRecord (this);
  return;
}
