/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_MULTIMEDIA_RECORD_HH_
#define _GEDCOMPARSER_MULTIMEDIA_RECORD_HH_

#include <map>
#include <string>

#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/AutomatedRecordIdManager.hh"
#include "GEDCOMParser/ChangelogManager.hh"
#include "GEDCOMParser/UserReferenceManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 MULTIMEDIA_RECORD structure     
  class MultimediaRecord:public GEDCOMElement,
    ///
    public AttachmentManager,
    public AutomatedRecordIdManager,
    public ChangelogManager, public UserReferenceManager
  {
  public:
    MultimediaRecord (std::string const &id = "");
      virtual ~ MultimediaRecord (void)
    {
    };

    ///@name Accessors (set) 
    //@{    
    ///
    void setId (std::string const &);
    ///
    void setForm (std::string const &);
    ///
    void setTitl (std::string const &);
    ///
    void contBlob (std::string const &);
    ///
    void setObjeXref (std::string const &);
    //@}
    ///@name Accessors (get)
    //@{    
    ///    
    virtual std::string const &getId (void) const;
    ///
    virtual std::string const &getForm (void) const;
    ///
    virtual std::string const &getTitl (void) const;
    ///
    virtual std::string const &getBlob (void) const;
    ///
    virtual std::string const &getObjeXref (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
      std::string _obje_id;
      std::string _form;
      std::string _titl;
      std::string _blob;
      std::string _obje_xref;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many multimedia records
  typedef std::map < std::string,
    SmartPtr < MultimediaRecord > >MultimediaRecords_t;
  //@}
};
#endif
