/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_MULTIMEDIA_LINK_
#define _GEDCOMPARSER_MULTIMEDIA_LINK_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  ///
  class MultimediaLink;
  ///@name typedefs
  //@{
  /// @doc handling of many multimedia links
  typedef std::vector < SmartPtr < MultimediaLink > >MultimediaLinks_t;
  //@}
};

#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/Attachment.hh"

///
namespace GEDCOMParser
{
  /// @memo Implements the GEDCOM 5.5 MULTIMEDIA_LINK structure   
  class MultimediaLink:public GEDCOMElement,
    ///
    public Attachment, public AttachmentManager
  {
  protected:
    std::string _obj_xref;
    std::string _format;
    std::string _title;
    std::string _mm_file_reference;
  public:
    virtual ~ MultimediaLink (void);
    ///@name Accessors (set) 
    //@{    
    ///
    void setObjXref (std::string const &);
    ///
    void setFormat (std::string const &);
    ///
    void setTitle (std::string const &);
    ///
    void setMMFileRef (std::string const &);
    //@}

    ///@name Accessors (get)
    //@{    
    ///
    virtual std::string const &getObjXref (void) const;
    ///
    virtual std::string const &getFormat (void) const;
    ///
    virtual std::string const &getTitle (void) const;
    ///
    virtual std::string const &getMMFileRef (void) const;
    //@}
    ///operator == used to find a multimedialink by its multimedia object xref
    friend bool operator== (MultimediaLink const &multimedia_link,
			    std::string const &obje_xref)
    {
      return (multimedia_link._obj_xref == obje_xref);
    };
    ///operator == used to find a multimedialink by its multimedia object xref
    friend bool operator== (MultimediaLink * const multimedia_link,
			    std::string const &obje_xref)
    {
      return (multimedia_link->_obj_xref == obje_xref);
    };
    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  };
};
#endif
