/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_ITEM_HH_
#define _GEDCOMPARSER_ITEM_HH_

///
namespace GEDCOMParser
{
  class Item
  {
  public:
    ///
    typedef enum
    {
      e_None,
      e_Address,
      e_Association,
      e_ChangeDate,
      e_ChildToFamilyLink,
      e_Data,
      e_FamilyEvent,
      e_Event,
      e_FamilyRecord,
      e_Gedc,
      e_Header,
      e_IndividualAttribute,
      e_IndividualEvent,
      e_IndividualRecord,
      e_LdsIndividualOrdinance,
      e_LdsSpouseSealing,
      e_MultimediaLink,
      e_MultimediaRecord,
      e_NoteStructure,
      e_NoteRecord,
      e_PersonalName,
      e_Place,
      e_RepositoryRecord,
      e_SourceCitation,
      e_SourceRecord,
      e_SourceRecord_Data,
      e_SourceRecord_Data_Event,
      e_SourceRepositoryCitation,
      e_SourceRepositoryCitation_SourceCallNumber,
      e_SpouseToFamilyLink,
      e_Submission,
      e_SubmitterRecord,
      e_UserReference
    }
    ///
    enumGedcomTypes;

  protected:
      ///
      enumGedcomTypes _typeid;
    ///
    void *_item;
  public:
      ///
      Item (void):_typeid (e_None), _item (0)
    {
    };
      ///
      Item (enumGedcomTypes id, void *item):_typeid (id), _item (item)
    {
    };
    ///
    Item & operator = (Item const &item)
    {
      _typeid = item._typeid;
      _item = item._item;
      return *this;
    };
    ///
    void *getValue (void)
    {
      return _item;
    };
    ///
    enumGedcomTypes getType (void)
    {
      return _typeid;
    };
  };

};
#endif
