/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif // HAVE_CONFIG_H

#include "IndividualEvent.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

#include "gettext.h"
#define _(String) dgettext(PACKAGE, String)


void
GEDCOMParser::IndividualEvent::setType (enumIndividualEvents type)
{
  _type = type;
  return;
}

void
GEDCOMParser::IndividualEvent::setFamcXref (std::string const &value)
{
  _famc_xref = value;
  return;
}

void
GEDCOMParser::IndividualEvent::setAdop (std::string const &value)
{
  _adop = value;
  return;
}

GEDCOMParser::IndividualEvent::enumIndividualEvents GEDCOMParser::
  IndividualEvent::getRawType (void) const
{
  return _type;
}

std::string const
GEDCOMParser::IndividualEvent::getType (void) const
{
  std::string res;
  switch (_type)
    {
    case e_None:
      res = (_("None"));
      break;
    case e_Birt:
      res = (_("Birth"));
      break;
    case e_Chr:
      res = (_("Christening"));
      break;
    case e_Deat:
      res = (_("Death"));
      break;
    case e_Buri:
      res = (_("Burial"));
      break;
    case e_Crem:
      res = (_("Cremation"));
      break;
    case e_Adop:
      res = (_("Adoption"));
      break;
    case e_Bapm:
      res = (_("Baptism"));
      break;
    case e_Barm:
      res = (_("BAR_MITZVAH"));
      break;
    case e_Basm:
      res = (_("BAS_MITZVAH"));
      break;
    case e_Bles:
      res = (_("Blessing"));
      break;
    case e_Chra:
      res = (_("Adult Christening"));
      break;
    case e_Conf:
      res = (_("Confirmation"));
      break;
    case e_Fcom:
      res = (_("First communion"));
      break;
    case e_Ordn:
      res = (_("Ordination"));
      break;
    case e_Natu:
      res = (_("Naturalization"));
      break;
    case e_Emig:
      res = (_("Emigration"));
      break;
    case e_Immi:
      res = (_("Immigration"));
      break;
    case e_Cens:
      res = (_("Census"));
      break;
    case e_Prob:
      res = (_("Probate"));
      break;
    case e_Will:
      res = (_("Will"));
      break;
    case e_Grad:
      res = (_("Graduation"));
      break;
    case e_Reti:
      res = (_("Retirement"));
      break;
    case e_Even:
      res = (_("Other event"));
      break;
    default:
      res = (_("Unmanaged event"));
      break;
    }
  return res;
}

std::string const &
GEDCOMParser::IndividualEvent::getFamcXref (void) const
{
  return _famc_xref;
}

std::string const &
GEDCOMParser::IndividualEvent::getAdop (void) const
{
  return _adop;
}

void
GEDCOMParser::IndividualEvent::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitIndividualEvent (this);
  return;
}
