/* 
   Copyright 2002 Cyril Picard

   This file is part of the GEDCOMParser library 
   (developed within the Genealogy Free Software Tools project).

   The GEDCOMParser library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   The GEDCOMParser library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the GEDCOMParser library ; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_ID_GENERATOR_HH_
#define _GEDCOMPARSER_ID_GENERATOR_HH_

#include <string>
#include "string_utility/Converter.hh"

///
namespace GEDCOMParser
{
  ///
  class IdGenerator
  {
  public:
    IdGenerator (void):_existing_ids (), _last_used_id (0)
    {
    };
      ///
      virtual ~ IdGenerator (void)
    {
    };
    ///
    std::string const getId (void);
    ///
    void addUsedId (std::string const &id);
  private:
    ///
    std::vector < std::string > _existing_ids;
    ///
    int _last_used_id;
  };
};


#endif
