/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_GEDCOMFACTORY_HH_
#define _GEDCOMPARSER_GEDCOMFACTORY_HH_

#include "GEDCOMParser/Address.hh"
#include "GEDCOMParser/Association.hh"
#include "GEDCOMParser/ChangeDate.hh"
#include "GEDCOMParser/ChildToFamilyLink.hh"
#include "GEDCOMParser/Data.hh"
#include "GEDCOMParser/Event.hh"
#include "GEDCOMParser/FamilyEvent.hh"
#include "GEDCOMParser/FamilyRecord.hh"
#include "GEDCOMParser/Header.hh"
#include "GEDCOMParser/IndividualAttribute.hh"
#include "GEDCOMParser/IndividualEvent.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/LdsIndividualOrdinance.hh"
#include "GEDCOMParser/LdsSpouseSealing.hh"
#include "GEDCOMParser/MultimediaLink.hh"
#include "GEDCOMParser/MultimediaRecord.hh"
#include "GEDCOMParser/NoteRecord.hh"
#include "GEDCOMParser/NoteStructure.hh"
#include "GEDCOMParser/PersonalName.hh"
#include "GEDCOMParser/Place.hh"
#include "GEDCOMParser/RepositoryRecord.hh"
#include "GEDCOMParser/SourceCitation.hh"
#include "GEDCOMParser/SourceRecord.hh"
#include "GEDCOMParser/SourceRepositoryCitation.hh"
#include "GEDCOMParser/SpouseToFamilyLink.hh"
#include "GEDCOMParser/Submission.hh"
#include "GEDCOMParser/SubmitterRecord.hh"
#include "GEDCOMParser/UserReference.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  /** @memo Factory used to create instances of GEDCOM data structures
      For more details check \URL[Factory pattern by Gopalan Suresh Raj]{http://gsraj.tripod.com/design/creational/factory/factory.html}
      If the link is broken, try  \URL[google]{http://www.google.com/search?hl=fr&q=factory+pattern+C%2B%2B}
  */
  class GEDCOMFactory
  {
  public:
    ///
    virtual Address * createAddress (void) const;
    ///
    virtual Association *createAssociation (void) const;
    ///
    virtual ChangeDate *createChangeDate (void) const;
    ///
    virtual ChildToFamilyLink *createChildToFamilyLink (void) const;
    ///
    virtual Data *createData (void) const;
    ///
    virtual Event *createEvent (void) const;
    ///
    virtual FamilyEvent *createFamilyEvent (void) const;
    ///
    virtual FamilyRecord *createFamilyRecord (std::string const &id =
					      "") const;
    ///
    virtual Header *createHeader (void) const;
    ///
    virtual IndividualAttribute *createIndividualAttribute (void) const;
    ///
    virtual IndividualEvent *createIndividualEvent (void) const;
    ///
    virtual IndividualRecord *createIndividualRecord (std::string const &id =
						      "") const;
    ///
    virtual LdsIndividualOrdinance *createLdsIndividualOrdinance (void) const;
    ///
    virtual LdsSpouseSealing *createLdsSpouseSealing (void) const;
    ///
    virtual MultimediaLink *createMultimediaLink (void) const;
    ///
    virtual MultimediaRecord *createMultimediaRecord (std::string const &id =
						      "") const;
    ///
    virtual NoteRecord *createNoteRecord (std::string const &id = "") const;
    ///
    virtual NoteStructure *createNoteStructure (void) const;
    ///
    virtual PersonalName *createPersonalName (void) const;
    ///
    virtual Place *createPlace (void) const;
    ///
    virtual RepositoryRecord *createRepositoryRecord (std::string const &id =
						      "") const;
    ///
    virtual SourceCitation *createSourceCitation (void) const;
    ///
    virtual SourceRecord *createSourceRecord (std::string const &id =
					      "") const;
    ///
    virtual SourceRecord::Data * createSourceRecord_Data (void) const;
    ///
    virtual SourceRecord::Data::Event *
      createSourceRecord_Data_Event (void) const;
    ///
    virtual SourceRepositoryCitation *createSourceRepositoryCitation (void)
      const;
    ///
    virtual SourceRepositoryCitation::SourceCallNumber *
      createSourceRepositoryCitation_SourceCallNumber (void) const;
    ///
    virtual SpouseToFamilyLink *createSpouseToFamilyLink (void) const;
    ///
    virtual Submission *createSubmission (void) const;
    ///
    virtual SubmitterRecord *createSubmitterRecord (std::string const &id =
						    "") const;
    ///
    virtual UserReference *createUserReference (void) const;
  };
};

#endif
