/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_FAMILYRECORD_HH_
#define _GEDCOMPARSER_FAMILYRECORD_HH_

#include <map>
#include <string>
#include <vector>

#include "GEDCOMParser/IndividualRecord.hh"
#include "GEDCOMParser/FamilyEvent.hh"
#include "GEDCOMParser/LdsSpouseSealing.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/AutomatedRecordIdManager.hh"
#include "GEDCOMParser/ChangelogManager.hh"
#include "GEDCOMParser/UserReferenceManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;

  ///@name typedefs
  //@{
  /// @doc handling of many child references
  typedef std::vector < std::string > ChildXrefs_t;
  //@}
  /// @memo Implements the GEDCOM 5.5 FAMILY_RECORD structure 
  class FamilyRecord:public GEDCOMElement,
    public AttachmentManager,
    public AutomatedRecordIdManager,
    public ChangelogManager, public UserReferenceManager
  {
  public:
    ///operator == used to find a family by its id
    friend bool operator== (FamilyRecord const &fam1,
			    std::string const &fam_id)
    {
      return (fam1._id == fam_id);
    };
      FamilyRecord (std::string const &id);
      virtual ~ FamilyRecord (void);
    ///@name Accessors (set) 
    //@{
    ///
    void setId (std::string const &);
    ///
      GEDCOMParser::FamilyEvent * addFamilyEvent (FamilyEvent * const data =
						  0);
    ///
    void setHusb (std::string const &);
    ///
    void setWife (std::string const &);
    ///
    void addChilXref (std::string const &);
    ///
    void RemoveChilXref (std::string const &);
    ///
    void setNchi (std::string const &);
    ///
    void setSubm (std::string const &);
    ///
      GEDCOMParser::LdsSpouseSealing * addLdsSpouseSealing (LdsSpouseSealing *
							    const data = 0);
    ///
    //@}

    ///@name Accessors (get)
    //@{    
    virtual std::string const &getId (void) const;
    ///
    FamilyEvents_t const &getFamilyEvents (void) const;
    ///
    virtual std::string const &getHusb (void) const;
    ///
    virtual std::string const &getWife (void) const;
    ///
    ChildXrefs_t const &getChilXrefs (void) const;
    ///
    virtual std::string const &getNchi (void) const;
    ///
    virtual std::string const &getSubm (void) const;
    ///
    LdsSpouseSealings_t const &getLdsSpouseSealings (void) const;
    //@}
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
      std::string _id;
    FamilyEvents_t _events;
      std::string _husb;
      std::string _wife;
    ChildXrefs_t _chil_xrefs;
      std::string _nchi;
      std::string _subm;
    LdsSpouseSealings_t _lds_spouse_sealings;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many family records (element)
  typedef std::pair < std::string,
    SmartPtr < FamilyRecord > >FamilyRecords_elem_t;
  /// @doc handling of many family records (association)
  typedef std::map < std::string, SmartPtr < FamilyRecord > >FamilyRecords_t;
  //@}
};
#endif
