/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_FAMILY_LINK_HH_
#define _GEDCOMPARSER_FAMILY_LINK_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/AttachmentManager.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  class FamilyLink:public GEDCOMElement, public AttachmentManager
  {
  public:
    virtual ~ FamilyLink (void)
    {
    };
    ///@name Accessors (set) 
    //@{
    ///
    void setFamXref (std::string const &);
    ///
    virtual std::string const &getFamXref (void) const;
    ///
    class IsEqualByFamXref
    {
    public:
      IsEqualByFamXref (std::string const &xref):_xref (xref)
      {
      };
        std::string _xref;
      bool operator  () (SmartPtr < GEDCOMParser::FamilyLink > const &link)
      {
	return _xref == link->getFamXref ();
      };
    };
    //@}
  protected:
    std::string _fam_xref;
  };
  ///@name typedefs
  //@{
  /// @doc handling of many familylinks
  typedef std::vector < SmartPtr < FamilyLink > >FamilyLinks_t;
  //@}
};



#endif
