/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _GEDCOMPARSER_FAMILY_EVENT_HH_
#define _GEDCOMPARSER_FAMILY_EVENT_HH_

#include <string>
#include <vector>
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMElement.hh"

/// Package GEDCOMParser
namespace GEDCOMParser
{
  class FamilyEvent;
  ///@name typedefs
  //@{
  /// @doc handling of many family events
  typedef std::vector < SmartPtr < FamilyEvent > >FamilyEvents_t;
  //@}
}

#include "GEDCOMParser/EventDetailManager.hh"

///
namespace GEDCOMParser
{
  class GEDCOMVisitor;
  /// @memo Implements the GEDCOM 5.5 FAMILY_EVENT_STRUCTURE structure 
  class FamilyEvent:public GEDCOMElement, public EventDetailManager
  {
  public:
    /// @memo Implements the GEDCOM 5.5 EVENT_TYPE_FAMILY enumeration (typedef'd to enumFamilyEvents)
    enum _enumFamilyEvents
    {
      ///
      e_None,
      ///
      e_Anul,
      ///
      e_Cens,
      ///
      e_Div,
      ///
      e_Divf,
      ///
      e_Enga,
      ///
      e_Marr,
      ///
      e_Marb,
      ///
      e_Marc,
      ///
      e_Marl,
      ///
      e_Mars,
      ///
      e_Even
	///
    };
    ///
    typedef enum _enumFamilyEvents enumFamilyEvents;

      ///
      FamilyEvent (enumFamilyEvents type = e_None):_type (type),
      _husb_age (), _wife_age ()
    {
    };
      ///
      FamilyEvent (FamilyEvent const &f):_type (f._type),
      _husb_age (f._husb_age), _wife_age (f._wife_age)
    {
    };
    ///
    virtual ~ FamilyEvent (void)
    {
    };
    ///@name Accessors (set) 
    //@{
    void setType (enumFamilyEvents);
    ///
    void setHusbAge (std::string const &);
    ///
    void setWifeAge (std::string const &);
    ///
    //@}

    ///@name Accessors (get)
    //@{ 
    enumFamilyEvents getRawType (void) const;
    ///
    std::string const getType (void) const;
    ///
    virtual std::string const &getHusbAge (void) const;
    ///
    virtual std::string const &getWifeAge (void) const;
    ///
    //@}


    /// operator == used to find an event by its type
    friend bool operator== (FamilyEvent const &eve, int type)
    {
      return (eve._type == (FamilyEvent::enumFamilyEvents) type);
    };
    ///
    virtual void Accept (GEDCOMParser::GEDCOMVisitor *);
  protected:
    ///
    enumFamilyEvents _type;
    ///
    std::string _husb_age;
    ///
    std::string _wife_age;
  };
};
#endif
