/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "GEDCOMParser/EventDetailManager.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

GEDCOMParser::Event *
  GEDCOMParser::EventDetailManager::setEvent (GEDCOMParser::Event * data)
{
  GEDCOMParser::Event * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createEvent ();
    }

  if (_event.Null ())
    {
      _event = SmartPtr < GEDCOMParser::Event > (tmp_data);
    }
  _event->copyLastUpdatedAttr (*tmp_data);
  return _event.getPtr ();
}

SmartPtr < GEDCOMParser::Event > const &
GEDCOMParser::EventDetailManager::getEvent (void) const
{
  return _event;
}

void
GEDCOMParser::EventDetailManager::removeEvent (void)
{
  _event.setNull ();
  return;
}
