/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include "Event.hh"
#include "patterns/SmartPtr.hh"
#include "GEDCOMParser/Visitor/GEDCOMVisitor.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMParser/GEDCOMFactoryAccessor.hh"

void
GEDCOMParser::Event::_setType (std::string const &value)
{
  _type = value;
  return;
}

void
GEDCOMParser::Event::_setDate (GEDCOMParser::DateManagement::
			       DateValue const &date)
{
  if ((_date != 0) && (_date != &date))
    {
      delete
	_date;
      _date = 0;
    }
  if (_date != &date)
    {
      _date = new GEDCOMParser::DateManagement::DateValue (date);
    }
  return;
}


void
GEDCOMParser::Event::_setPlace (SmartPtr < GEDCOMParser::Place > const &value)
{
  _place = value;
  return;
}

void
GEDCOMParser::Event::_setAddress (GEDCOMParser::Address * const data)
{
  GEDCOMParser::AddressManager::setAddress (data);
  return;
}

void
GEDCOMParser::Event::_setAge (std::string const &value)
{
  _age = value;
  return;
}

void
GEDCOMParser::Event::_setAgnc (std::string const &value)
{
  _agnc = value;
  return;
}

void
GEDCOMParser::Event::_setCaus (std::string const &value)
{
  _caus = value;
  return;
}

void
GEDCOMParser::Event::_addAttachment (SmartPtr < GEDCOMParser::Attachment >
				     const &data)
{
  GEDCOMParser::AttachmentManager::addAttachment (data);
  return;
}

void
GEDCOMParser::Event::setType (std::string const &value)
{
  _type = value;
  _updated_attr = e_Type;
  return;
}

void
GEDCOMParser::Event::setDate (std::string const &value)
{
  if (_date == 0)
    {
      _date = new GEDCOMParser::DateManagement::DateValue (value);
    }
  else
    {
      _date->setValue (value);
    }
  _updated_attr = e_Date;
  return;
}

GEDCOMParser::Place * GEDCOMParser::Event::setPlace (GEDCOMParser::Place *
						     const data = 0)
{
  GEDCOMParser::Place * tmp_data = data;
  if (data == 0)
    {
      GEDCOMParser::GEDCOMFactory * factory =
	GEDCOMParser::GEDCOMFactoryAccessor::getFactory ();
      tmp_data = factory->createPlace ();
    }
  _setPlace (SmartPtr < Place > (tmp_data));
  _updated_attr = e_Place;
  return _place.getPtr ();
}

void
GEDCOMParser::Event::setAddress (GEDCOMParser::Address * const data)
{
  _setAddress (data);
  _updated_attr = e_Address;
  return;
}

void
GEDCOMParser::Event::setAge (std::string const &value)
{
  _setAge (value);
  _updated_attr = e_Age;
  return;
}

void
GEDCOMParser::Event::setAgnc (std::string const &value)
{
  _setAgnc (value);
  _updated_attr = e_Agnc;
  return;
}

void
GEDCOMParser::Event::setCaus (std::string const &value)
{
  _setCaus (value);
  _updated_attr = e_Caus;
  return;
}

void
GEDCOMParser::Event::addAttachment (GEDCOMParser::Attachment * const data)
{
  GEDCOMParser::AttachmentManager::addAttachment (data);
  _updated_attr = e_Attachment;
  return;
}

void
GEDCOMParser::Event::addMultimediaLink (GEDCOMParser::Attachment * const data)
{
  addAttachment (data);
  return;
}

void
GEDCOMParser::Event::addNoteStructure (GEDCOMParser::Attachment * const data)
{
  addAttachment (data);
  return;
}

void
GEDCOMParser::Event::addSourceCitation (GEDCOMParser::Attachment * const data)
{
  addAttachment (data);
  return;
}

void
GEDCOMParser::Event::copyLastUpdatedAttr (GEDCOMParser::Event const &e)
{
  switch (e._updated_attr)
    {
    case e_Type:
      {
	_setType (e._type);
	break;
      }
    case e_Date:
      {
	_setDate (*(e._date));
	break;
      }
    case e_Place:
      {
	_setPlace (e._place);
	break;
      }
    case e_Address:
      {
	_setAddress (e.getAddress ().getPtr ());
	break;
      }
    case e_Age:
      {
	_setAge (e._age);
	break;
      }
    case e_Agnc:
      {
	_setAgnc (e._agnc);
	break;
      }
    case e_Caus:
      {
	_setCaus (e._caus);
	break;
      }
    case e_Attachment:
      {
	_addAttachment ((e.getAttachments ().back ()));
	break;
      }
    default:
      {
	break;
      }
    }
  return;
}

void
GEDCOMParser::Event::resetLastUpdatedAttr (void)
{
  _updated_attr = e_None;
  return;
}

SmartPtr < GEDCOMParser::Place > const &
GEDCOMParser::Event::getPlace (void) const
{
  return _place;
}

GEDCOMParser::Event::enumAttributes const
GEDCOMParser::Event::getUpdatedAttr (void) const
{
  return _updated_attr;
}

std::string const &
GEDCOMParser::Event::getType (void) const
{
  return _type;
}

std::string const
GEDCOMParser::Event::getDate (void) const
{
  std::string res;
  if (_date != 0)
    {
      res = _date->getDisplayValue ();
    }
  return res;
}

GEDCOMParser::DateManagement::DateValue const *const
GEDCOMParser::Event::getDateObject (void) const
{
  return _date;
}

std::string const &
GEDCOMParser::Event::getAge (void) const
{
  return _age;
}

std::string const &
GEDCOMParser::Event::getAgnc (void) const
{
  return _agnc;
}

std::string const &
GEDCOMParser::Event::getCaus (void) const
{
  return _caus;
}

void
GEDCOMParser::Event::Accept (GEDCOMParser::GEDCOMVisitor * v)
{
  v->VisitEvent (this);
  return;
}
