/*
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_DATEMANAGEMENT_DATEVALUEPARSER_DECL_H_
#define _GEDCOMPARSER_DATEMANAGEMENT_DATEVALUEPARSER_DECL_H_
#include <stdio.h>

#define	yymaxdepth datevalue_maxdepth
#define	yyparse	datevalue_parse
#define	yyerror	datevalue_error
#define	yylval	datevalue_lval
#define	yychar	datevalue_char
#define	yydebug	datevalue_debug
#define	yypact	datevalue_pact	
#define	yyr1	datevalue_r1			
#define	yyr2	datevalue_r2			
#define	yydef	datevalue_def		
#define	yychk	datevalue_chk		
#define	yypgo	datevalue_pgo		
#define	yyact	datevalue_act		
#define	yyexca	datevalue_exca
#define yyerrflag datevalue_errflag
#define yynerrs	datevalue_nerrs
#define	yyps	datevalue_ps
#define	yypv	datevalue_pv
#define	yys	datevalue_s
#define	yy_yys	datevalue_yys
#define	yystate	datevalue_state
#define	yytmp	datevalue_tmp
#define	yyv	datevalue_v
#define	yy_yyv	datevalue_yyv
#define	yyval	datevalue_val
#define	yylloc	datevalue_lloc
#define yyreds	datevalue_reds
#define yytoks	datevalue_toks
#define yylhs	datevalue_yylhs
#define yylen	datevalue_yylen
#define yydefred datevalue_yydefred
#define yydgoto	datevalue_yydgoto
#define yysindex datevalue_yysindex
#define yyrindex datevalue_yyrindex
#define yygindex datevalue_yygindex
#define yytable	 datevalue_yytable
#define yycheck	 datevalue_yycheck


#define YYSTYPE char *

#define YYDEBUG 1
struct yy_buffer_state * datevalue_scan_string(const char *);
#include <string>
#include "GEDCOMParser/DateManagement/DateValue.hh"
#include "GEDCOMParser/DateManagement/Date.hh"
#include "GEDCOMParser/DateManagement/Period.hh"
#include "GEDCOMParser/DateManagement/Range.hh"
#include "GEDCOMParser/DateManagement/DatePhrase.hh"

void datevalue_runparse(std::string const &, GEDCOMParser::DateManagement::DateValue * date_value, int debug = 0);
#endif
