/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_DATEMANAGEMENT_RANGE_HH_
#define _GEDCOMPARSER_DATEMANAGEMENT_RANGE_HH_

#include "GEDCOMParser/DateManagement/Date.hh"

///
namespace GEDCOMParser
{
  ///
  namespace DateManagement
  {
    /** @memo Implements the GEDCOM 5.5 DATE_RANGE primitive element
     **/
    class Range
    {
    public:
      /// @memo Implements the range types enumeration (typedef'd to enumRangeTypes)
      enum _enumRangeTypes
      {
	///
	e_Null,
	///
	e_Before,
	///
	e_After,
	///
	e_Between
      };
      ///
      typedef enum _enumRangeTypes enumRangeTypes;
        Range (void):_type (e_Null), _bound1 (0), _bound2 (0)
      {
      };
        ///
        Range (Range const &r):_type (r._type), _bound1 (0), _bound2 (0)
      {
	if (r._bound1 != 0)
	  {
	    _bound1 = new GEDCOMParser::DateManagement::Date (*r._bound1);
	  }
	if (r._bound2 != 0)
	  {
	    _bound2 = new GEDCOMParser::DateManagement::Date (*r._bound2);
	  }
	return;
      };
      ///
      ~Range (void)
      {
	delete _bound1;
	_bound1 = 0;
	delete _bound2;
	_bound2 = 0;
	return;
      };
      ///@name Accessors (set) 
      //@{
      /// 
      void setType (enumRangeTypes type);
      ///
      void setBound1 (GEDCOMParser::DateManagement::Date const &bound1);
      ///
      void setBound2 (GEDCOMParser::DateManagement::Date const &bound2);
      //@}

      ///@name Accessors (get)
      //@{ 
      ///
      std::string const getDisplayValue (void) const;
      //@}
    private:
      enumRangeTypes _type;
      ///
      GEDCOMParser::DateManagement::Date * _bound1;
      ///
      GEDCOMParser::DateManagement::Date * _bound2;
    };
  };
};

#endif
