/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_DATEMANAGEMENT_PERIOD_HH_
#define _GEDCOMPARSER_DATEMANAGEMENT_PERIOD_HH_

#include "GEDCOMParser/DateManagement/Date.hh"
////
namespace GEDCOMParser
{
  ///
  namespace DateManagement
  {
    /** @memo Implements the GEDCOM 5.5 DATE_PERIOD primitive element
     **/
    class Period
    {
    public:
      Period (void):_date_from (0), _date_to (0)
      {
      };
        ///
        Period (Period const &p):_date_from (0), _date_to (0)
      {
	if (p._date_from != 0)
	  {
	    _date_from =
	      new GEDCOMParser::DateManagement::Date (*p._date_from);
	  }
	if (p._date_to != 0)
	  {
	    _date_to = new GEDCOMParser::DateManagement::Date (*p._date_to);
	  }
      };
      ///
      ~Period (void)
      {
	delete _date_from;
	delete _date_to;
	return;
      };
      ///@name Accessors (set) 
      //@{
      /// 
      void setDateFrom (GEDCOMParser::DateManagement::Date const &from);
      /// 
      void setDateTo (GEDCOMParser::DateManagement::Date const &to);
      //@}

      ///@name Accessors (get)
      //@{ 
      ///
      std::string const getDisplayValue (void) const;
      //@}
    private:
      GEDCOMParser::DateManagement::Date * _date_from;
      ///
      GEDCOMParser::DateManagement::Date * _date_to;
    };
  };
};

#endif
