/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_DATEMANAGEMENT_DATEVALUE_HH_
#define _GEDCOMPARSER_DATEMANAGEMENT_DATEVALUE_HH_


#include "GEDCOMParser/DateManagement/Date.hh"
#include "GEDCOMParser/DateManagement/DatePhrase.hh"
#include "GEDCOMParser/DateManagement/Range.hh"
#include "GEDCOMParser/DateManagement/Period.hh"
#include <string>

/// Package GEDCOMParser
namespace GEDCOMParser
{
  /// Implements the dates management (essentially parsing) in GEDCOM files
  namespace DateManagement
  {
    /** @memo Implements the GEDCOM 5.5 DATE_VALUE primitive element
     **/
    class DateValue
    {
    public:
      /// @memo Implements the range types enumeration (typedef'd to enumRangeTypes)
      enum _enumDateValueTypes
      {
	///
	e_Null,
	///
	e_Date,
	///
	e_DatePhrase,
	///
	e_Range,
	///
	e_Period,
	///
	e_Interpreted
      };
      typedef enum _enumDateValueTypes enumDateValueTypes;
        DateValue (void):_parsing_ko (true),
	_raw_value (),
	_type (e_Null), _date (0), _date_phrase (0), _period (0), _range (0)
      {
	return;
      };
        DateValue (DateValue const &d):_parsing_ko (d._parsing_ko),
	_raw_value (d._raw_value),
	_type (d._type), _date (0), _date_phrase (0), _period (0), _range (0)
      {
	if (d._date != 0)
	  _date = new GEDCOMParser::DateManagement::Date (*d._date);
	if (d._date_phrase != 0)
	  _date_phrase =
	    new GEDCOMParser::DateManagement::DatePhrase (*d._date_phrase);
	if (d._period != 0)
	  _period = new GEDCOMParser::DateManagement::Period (*d._period);
	if (d._range != 0)
	  _range = new GEDCOMParser::DateManagement::Range (*d._range);
	return;
      };
        DateValue (std::string const &value);
       ~DateValue (void)
      {
	delete _date;
	  _date = 0;
	delete _date_phrase;
	  _date_phrase = 0;
	delete _period;
	  _period = 0;
	delete _range;
	  _range = 0;
      };
      ///@name Accessors (set) 
      //@{
      ///
      void setType (enumDateValueTypes type);
      ///
      void setDate (GEDCOMParser::DateManagement::Date const &date);
      ///
      void setDatePhrase (GEDCOMParser::DateManagement::
			  DatePhrase const &date_phrase);
      ///
      void setPeriod (GEDCOMParser::DateManagement::Period const &period);
      ///
      void setRange (GEDCOMParser::DateManagement::Range const &range);
      ///
      void setValue (std::string const &value);
      ///
      void setParseError (bool);
      //@}

      ///@name Accessors (get)
      //@{ 
      ///
      std::string const getDisplayValue (void) const;
      std::string const &getRawValue (void) const;
      //@}
    private:
      bool _parsing_ko;
      std::string _raw_value;
      enumDateValueTypes _type;
      GEDCOMParser::DateManagement::Date * _date;
      GEDCOMParser::DateManagement::DatePhrase * _date_phrase;
      GEDCOMParser::DateManagement::Period * _period;
      GEDCOMParser::DateManagement::Range * _range;
    };
  };
};

#endif
