/* 
    Copyright 2002 Cyril Picard

    This file is part of the GEDCOMParser library 
    (developed within the Genealogy Free Software Tools project).

    The GEDCOMParser library is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    The GEDCOMParser library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with the GEDCOMParser library ; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMPARSER_ATTACHMENT_MANAGER_HH_
#define _GEDCOMPARSER_ATTACHMENT_MANAGER_HH_

#include "GEDCOMParser/Attachment.hh"
#include <string>

///
namespace GEDCOMParser
{
  class MultimediaLink;
  class SourceCitation;
  class NoteStructure;

}

///
namespace GEDCOMParser
{
  ///@name Abstract classes
  //@{
  ///
  class AttachmentManager
  {
  public:
    ///
    typedef std::vector < MultimediaLink * >MultimediaLinks_t;
    ///
    typedef std::vector < NoteStructure * >NoteStructures_t;
    ///
    typedef std::vector < SourceCitation * >SourceCitations_t;
    ///
      GEDCOMParser::Attachment * addAttachment (Attachment * const data);
    ///
      GEDCOMParser::Attachment * addAttachment (SmartPtr < Attachment >
						const &data);
    ///
      GEDCOMParser::MultimediaLink * addMultimediaLink (MultimediaLink *
							const data = 0);
    ///
      GEDCOMParser::NoteStructure * addNoteStructure (NoteStructure *
						      const data = 0);
    ///
      GEDCOMParser::SourceCitation * addSourceCitation (SourceCitation *
							const data = 0);
    /// 
      GEDCOMParser::Attachments_t const &getAttachments (void) const;
    ///
    MultimediaLinks_t const &getMultimediaLinks (void) const;
    ///
    NoteStructures_t const &getNoteStructures (void) const;
    ///
    SourceCitations_t const &getSourceCitations (void) const;
    ///
    void removeAttachment (Attachment * const data);
    ///
    void removeMultimediaLink (MultimediaLink * const data);
    ///
    void removeMultimediaLink (std::string const &obje_xref);
    ///
    void removeNoteStructure (NoteStructure * const data);
    ///
    void removeNoteStructure (std::string const &note_xref);
    ///
    void removeSourceCitation (SourceCitation * const data);
    ///
    void removeSourceCitation (std::string const &source_xref);
    ///
      virtual ~ AttachmentManager (void)
    {
    };
  private:
      Attachments_t _attachments;
    ///
    MultimediaLinks_t _multimedia_links;
    ///
    NoteStructures_t _note_structures;
    ///
    SourceCitations_t _source_citations;
  };
  //@}
};

#endif
