/* 
   Copyright 2002 Cyril Picard

   This file is part of the GEDCOMParser library 
   (developed within the Genealogy Free Software Tools project).

   The GEDCOMParser library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   The GEDCOMParser library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the GEDCOMParser library ; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef _GEDCOMHELPER_FAMILY_RECORD_HELPER_HH_
#define _GEDCOMHELPER_FAMILY_RECORD_HELPER_HH_

#include "GEDCOMParser/FamilyRecord.hh"
#include "GEDCOMParser/LineageLinkageGedcom.hh"
#include "GEDCOMParser/IndividualEvent.hh"
#include "GEDCOMParser/IndividualRecord.hh"
#include "patterns/SmartPtr.hh"
#include <string>

///
namespace GEDCOMHelper
{
  class FamilyRecordHelper
  {
  public:
    ///
    FamilyRecordHelper (GEDCOMParser::FamilyRecord * const family_record,
			GEDCOMParser::
			LineageLinkageGedcom &
			lineage):_family_record (family_record),
      _lineage (&lineage)
    {
    };
      ///
      FamilyRecordHelper (GEDCOMParser::FamilyRecord * const family_record,
			  GEDCOMParser::LineageLinkageGedcom *
			  const lineage):_family_record (family_record),
      _lineage (lineage)
    {
    };

  ///
  FamilyRecordHelper (SmartPtr < GEDCOMParser::FamilyRecord > &family_record, GEDCOMParser::LineageLinkageGedcom & lineage):
    _family_record (family_record.getPtr ()), _lineage (&lineage)
    {
    };
    //@{      
    GEDCOMParser::FamilyRecord * const FamilyRecord (void) const
    {
      return _family_record;
    }
    /// set Husband or Wife according to the sex of individual
    void setSpouse (GEDCOMParser::IndividualRecord const &individual_record);
    ///
    void setSpouse (SmartPtr < GEDCOMParser::IndividualRecord >
		    const &individual_record);
    /// return the ID of the spouse of individual
    std::string getSpouseId (GEDCOMParser::
			     IndividualRecord const &individual_record) const;
    ///
    void RemoveSpouse (GEDCOMParser::
		       IndividualRecord const &individual_record);
    ///
    GEDCOMParser::FamilyEvent * getMarriageEvent (void) const;
    GEDCOMParser::FamilyEvent * setMarriage (std::string const &date,
					     std::string const &location);

  private:
    ///
    GEDCOMParser::FamilyRecord * const _family_record;
    ///
    GEDCOMParser::LineageLinkageGedcom * const _lineage;
    ///
    GEDCOMParser::FamilyEvent *
      const getEvent (GEDCOMParser::FamilyEvent::
		      enumFamilyEvents const &event_type) const;
    ///
    GEDCOMParser::FamilyEvent *
      setEvent (GEDCOMParser::FamilyEvent::enumFamilyEvents const &event_type,
		std::string const &date, std::string const &location);
  };
};



#endif
