#    Copyright 2002 Cyril Picard
#
#    This file is part of the GEDCOMParser library 
#    (developed within the Genealogy Free Software Tools project).
#
#    The GEDCOMParser library is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    The GEDCOMParser library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with the GEDCOMParser library ; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#

dnl Test for GEDCOMPARSER, and define GEDCOMPARSER_CFLAGS and GEDCOMPARSER_LIBS
dnl   to be used as follows:
dnl AM_PATH_GEDCOMPARSER([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl
AC_DEFUN(AM_PATH_GEDCOMPARSER,
[dnl 
dnl Get the cflags and libraries from the gedcomparser-config script
dnl
AC_ARG_WITH(gedcomparser-prefix,[  --with-gedcomparser-prefix=PREFIX
                          Prefix where GEDCOMPARSER is installed (optional)],
            gedcomparser_config_prefix="$withval", gedcomparser_config_prefix="")
AC_ARG_WITH(gedcomparser-exec-prefix,[  --with-gedcomparser-exec-prefix=PREFIX
                          Exec prefix where GEDCOMPARSER is installed (optional)],
            gedcomparser_config_exec_prefix="$withval", gedcomparser_config_exec_prefix="")
AC_ARG_ENABLE(gedcomparsertest, [  --disable-gedcomparsertest     Do not try to compile and run a test GEDCOMPARSER program],
		    , enable_gedcomparsertest=yes)

  if test x$gedcomparser_config_exec_prefix != x ; then
     gedcomparser_config_args="$gedcomparser_config_args --exec-prefix=$gedcomparser_config_exec_prefix"
     if test x${GEDCOMPARSER_CONFIG+set} != xset ; then
        GEDCOMPARSER_CONFIG=$gedcomparser_config_exec_prefix/bin/gedcomparser-config
     fi
  fi
  if test x$gedcomparser_config_prefix != x ; then
     gedcomparser_config_args="$gedcomparser_config_args --prefix=$gedcomparser_config_prefix"
     if test x${GEDCOMPARSER_CONFIG+set} != xset ; then
        GEDCOMPARSER_CONFIG=$gedcomparser_config_prefix/bin/gedcomparser-config
     fi
  fi

  AC_PATH_PROG(GEDCOMPARSER_CONFIG, gedcomparser-config, no)
  min_gedcomparser_version=ifelse([$1], ,0.1.0,$1)

  AC_MSG_CHECKING(for GEDCOMPARSER - version >= $min_gedcomparser_version)
  AC_LANG_SAVE
  no_gedcomparser=""
  if test "$GEDCOMPARSER_CONFIG" = "no" ; then
    no_gedcomparser=yes
  else
    AC_LANG_CPLUSPLUS

    GEDCOMPARSER_CFLAGS=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --cflags gedcomparser`
    GEDCOMHELPER_CFLAGS=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --cflags gedcomhelper`
    GEDCOMPARSER_LIBS=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --libs gedcomparser`
    GEDCOMHELPER_LIBS=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --libs gedcomhelper`
    gedcomparser_config_major_version=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
    gedcomparser_config_minor_version=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
    gedcomparser_config_micro_version=`$GEDCOMPARSER_CONFIG $gedcomparser_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
    if test "x$enable_gedcomparsertest" = "xyes" ; then
      ac_save_CXXFLAGS="$CXXFLAGS"
      ac_save_LIBS="$LIBS"
      CXXFLAGS="$CXXFLAGS $GEDCOMPARSER_CFLAGS $GEDCOMHELPER_CFLAGS"
      LIBS="$LIBS $GEDCOMPARSER_LIBS $GEDCOMHELPER_LIBS"
dnl
dnl Now check if the installed GEDCOMPARSER is sufficiently new. (Also sanity
dnl checks the results of gedcomparser-config to some extent
dnl
      rm -f conf.gedcomparsertest
      AC_TRY_RUN([

#include "GEDCOMParser/Parser.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include "GEDCOMHelper/IndividualRecordHelper.hh"

int 
main ()
{
  system ("touch conf.gedcomparsertest");	
  GEDCOMParser::GEDCOMFactory factory;
  GEDCOMParser::Parser viewparser(&factory);	
  GEDCOMHelper::IndividualRecordHelper(0,0);
  return 0;
}
],, no_gedcomparser=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])
       CXXFLAGS="$ac_save_CXXFLAGS"
       LIBS="$ac_save_LIBS"
     fi
  fi
  if test "x$no_gedcomparser" = x ; then
     AC_MSG_RESULT(yes)
     ifelse([$2], , :, [$2])     
  else
     AC_MSG_RESULT(no)
     if test "$GEDCOMPARSER_CONFIG" = "no" ; then
       echo "*** The gedcomparser-config script installed by GEDCOMPARSER could not be found"
       echo "*** If GEDCOMPARSER was installed in PREFIX, make sure PREFIX/bin is in"
       echo "*** your path, or set the GEDCOMPARSER_CONFIG environment variable to the"
       echo "*** full path to gedcomparser-config."
       echo "*** The gedcomparser-config script was not available in GEDCOMPARSER versions"
       echo "*** prior to 0.1.2. Perhaps you need to update your installed"
       echo "*** version to 0.1.2 or later"
     else
       if test -f conf.gedcomparsertest ; then
        :
       else
          echo "*** Could not run GEDCOMPARSER test program, checking why..."
          CXXFLAGS="$CXXFLAGS $GEDCOMPARSER_CFLAGS"
          LIBS="$LIBS $GEDCOMPARSER_LIBS"
          AC_TRY_LINK([

#include "GEDCOMParser/Parser.hh"
#include "GEDCOMParser/GEDCOMFactory.hh"
#include <stdio.h>
],, 
        [ echo "*** The test program compiled, but did not run. This usually means"
          echo "*** that the run-time linker is not finding GEDCOMPARSER or finding the wrong"
          echo "*** version of GEDCOMPARSER. If it is not finding GEDCOMPARSER, you'll need to set your"
          echo "*** LD_LIBRARY_PATH environment variable, or edit /etc/ld.so.conf to point"
          echo "*** to the installed location  Also, make sure you have run ldconfig if that"
          echo "*** is required on your system"
	  echo "***"
          echo "*** If you have an old version installed, it is best to remove it, although"
          echo "*** you may also be able to get things to work by modifying LD_LIBRARY_PATH" ],
        [ echo "*** The test program failed to compile or link. See the file config.log for the"
          echo "*** exact error that occured. This usually means GEDCOMPARSER was incorrectly installed"
          echo "*** or that you have moved GEDCOMPARSER since it was installed. In the latter case, you"
          echo "*** may want to edit the gedcomparser-config script: $GEDCOMPARSER_CONFIG" ])
          CXXFLAGS="$ac_save_CXXFLAGS"
          LIBS="$ac_save_LIBS"
       fi
     fi
     GEDCOMPARSER_CFLAGS=""
     GEDCOMPARSER_LIBS=""
     ifelse([$3], , :, [$3])
  fi
  AC_LANG_RESTORE
  AC_SUBST(GEDCOMPARSER_CFLAGS)
  AC_SUBST(GEDCOMPARSER_LIBS)
  AC_SUBST(GEDCOMHELPER_CFLAGS)
  AC_SUBST(GEDCOMHELPER_LIBS)
  rm -f conf.gedcomparsertest
])

