# -*- coding: utf-8 -*-
# Copyright (C) 2010  Carlos Pais  <carlosfvpais@gmail.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
GetMediumURL plugin for Sapo (videos.sapo.pt) videos.
"""


from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import Format


__all__ = ("Sapovideos",)


class SapovideosMedium(HTMLMedium):

    """A Sapo video."""

    url_format = "http://videos.sapo.pt/%s"

    def __iter__(self):
        """Iterate formats."""
        yield Format(url=self.get_content_substring(start="play?file=",
                                                          end="&quot;"))


class Sapovideos(HTMLPlugin):

    """Plugin for Sapo videos"""

    url_format = "http://videos.sapo.pt/%s"
    medium_class = SapovideosMedium
