# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Test `getmediumurl.plugins.file`.
"""


import os.path
import unittest


__all__ = ("FileTestCase",)


class FileTestCase(unittest.TestCase):

    """Tests for the file plugin."""

    def setUp(self):
        """Prepare."""
        import pkg_resources
        self.htdocs = pkg_resources.resource_filename("tests_getmediumurl",
                                                      "htdocs")

    def test_html_not_matched(self):
        """Test that a local HTML page is not matched."""
        from getmediumurl import Matcher
        self.assertEquals(Matcher().match(os.path.join(self.htdocs,
                                                       "titled.html")),
                          None)
