# -*- coding: utf-8 -*- #
# Copyright (C) 2008, 2009 Leonardo Gastón De Luca leo[at]kde.org.ar
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
GetMediumURL plugin for Xnxx videos.
"""


import re

from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import SimpleFormat


__all__ = ("Xnxx",)


class XnxxMedium(HTMLMedium):

    """A video on Xnxx."""

    url_format = "http://video.xnxx.com/video%s"

    def __iter__(self):
        """Iterate formats."""
        yield SimpleFormat(url=self.get_content_substring("flv_url=", ".flv"))


class Xnxx(HTMLPlugin):

    """Plugin for Xnxx videos"""

    match_re = re.compile(r'^http://video\.xnxx\.com/video(?P<mediumid>\d+)')
    medium_class = XnxxMedium
