# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""Plugin for Metacafe videos."""


import re
from getmediumurl.compat import parse_qs

from getmediumurl.cache import cachedproperty
from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.format import SimpleFormat


__all__ = ("Metacafe",)


class MetacafeMedium(HTMLMedium):

    """A Metacafe video."""

    raw_url_format = "http://www.metacafe.com/watch/%s/"

    @cachedproperty
    def _flashvars(self):
        """Variables used by the Flash player."""
        return parse_qs(self.page.xpath("//param[@name='flashvars']"
                                        "/@value")[0])

    @cachedproperty
    def title(self):
        """Video title."""
        return self._flashvars["title"][0]

    @cachedproperty
    def author_name(self):
        """Video submitter user name."""
        return self._flashvars["nickName"][0]

    @cachedproperty
    def author_url(self):
        """Video submitter profile URL."""
        return "http://www.metacafe.com/channels/%s/" % self.author_name

    @cachedproperty
    def description(self):
        """Video description."""
        return " ".join(self._flashvars["description"][0].split())

    # Based on a method originally written by Carlos Pais.
    def __iter__(self):
        """Iterate formats."""
        mediaurl = self._flashvars["mediaURL"][0]
        gdakey = self._flashvars["gdaKey"][0]
        yield SimpleFormat(url="%s?__gda__=%s" % (mediaurl, gdakey))


class Metacafe(HTMLPlugin):

    """Plugin for Metacafe."""

    match_re = re.compile("^http://www\.metacafe\.com/watch/"
                          "(?P<mediumid>\d+)/")
    medium_class = MetacafeMedium
