# -*- coding: utf-8 -*-
# Copyright (C) 2008, 2009 Leonardo Gastón De Luca leo[at]kde.org.ar
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Plugin for CollegeHumor videos.
"""


import re

from getmediumurl.cache import cachedproperty
from getmediumurl.format import SimpleFormat
from getmediumurl.htmlplugin import HTMLPlugin, HTMLMedium
from getmediumurl.xmlhtml import read_xml


__all__ = ("CollegeHumor",)


class CollegeHumorMedium(HTMLMedium):

    """Video on CollegeHumor."""

    url_format = u"http://www.collegehumor.com/video:%s"
    website_name = u"CollegeHumor"

    @cachedproperty
    def author_name(self):
        """Author profile name."""
        return self.page.xpath("//p[@class='byLine']/a/text()")[0]

    @cachedproperty
    def author_url(self):
        """Author profile URL."""
        return self.make_absolute(self.page.xpath("//p[@class='byLine']"
                                                  "/a/@href")[0])

    def __iter__(self):
        """Return an interable of supported medium formats."""
        address = "http://www.collegehumor.com/moogaloop/video:%s" \
            % self.mediumid
        api_xml = read_xml(self.urlreader(address).content)
        yield SimpleFormat(api_xml.findtext("video/file"),
                           mime_type="video/mp4")


class CollegeHumor(HTMLPlugin):

    """Plugin for CollegeHumor videos."""

    match_re = re.compile(r'^http://www\.collegehumor\.com/video:'
                          '(?P<mediumid>\d+)')
    medium_class = CollegeHumorMedium
