# -*- coding: utf-8 -*-
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


"""
Code useful for many tests of GetMediumURL.
"""


from getmediumurl.xmlhtml import CAN_READ_HTML


def requirehtml(method):
    """Decorator for ``TestCase`` methods to skip them if cannot read HTML."""

    def new_method(self):
        """Skip if not `CAN_READ_HTML`."""
        if not CAN_READ_HTML:
            # Needs Python 2.7.
            try:
                self.skipTest("requires lxml or html5lib")
            except AttributeError:
                return
        return method(self)

    new_method.__doc__ = method.__doc__
    return new_method
