#!/bin/sh
# Copyright (C) 2010  Michał Masłowski  <mtjm@mtjm.eu>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.
#
# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


# Call tests, use static code checkers and make API documentation.

run_coverage() {
    PYTHONPATH=.:$PYTHONPATH \
	coverage run --source=getmediumurl --branch $@ || exit 1
}

rm -rf build/lib*

ln -sf tests_getmediumurl/__init__.py do_tests.py

if [ ! -z $(which coverage 2> /dev/null) ]
then
    run_coverage do_tests.py
    # Uses http://hg.mtjm.eu/getmediumurl-plugin-test/
    [ -e plugin_test.py ] && run_coverage -a plugin_test.py
    coverage html --omit='/usr*,*tests_getmediumurl*,setup.py'
else
    python do_tests.py || exit 1
fi

rm do_tests.py

# Test other Python versions.
for version in 2.5 2.6 2.7 3.1
do
    if [ ! -z $(which python$version 2> /dev/null) ]
    then
	rm -rf build/lib*
	python$version setup.py test -q || exit 1
    fi
done

pyflakes getmediumurl
pylint \
    --disable=W0105 \
    --enable=W0704 \
    --output-format=colorized \
    --include-ids=y \
    --max-args=6 \
    --report=n \
    getmediumurl
pylint \
    --disable=W0105 \
    --disable=W0201 \
    --disable=R0904 \
    --disable=W0401 \
    --disable=W0406 \
    --disable=R0903 \
    --disable=W0622 \
    --disable=W0603 \
    --enable=W0704 \
    --good-names=setUp,tearDown \
    --generated-members=skipTest \
    --output-format=colorized \
    --include-ids=y \
    --report=n \
    tests_getmediumurl
pep8 getmediumurl tests_getmediumurl

if [ "x$DO_APIDOCS" = xyes ]
then
    epydoc -v --config epydoc.cfg
fi

# Support both Debian's modified docutils script names and the
# upstream ones.
if [ ! -z $(which rst2html 2> /dev/null) ]
then
    RST2HTML=rst2html
else
    RST2HTML=rst2html.py
fi

for doc in README NEWS
do
    $RST2HTML $doc.txt $doc.html
done
